/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.payments;

import de.rtb.pcon.ui.controllers.reports.payments.CategoryStrategy;
import java.time.Duration;
import java.time.LocalTime;

class TimeCategoryStrategy
implements CategoryStrategy<LocalTime> {
    private Duration categoryDuration;

    public TimeCategoryStrategy(Duration categoryDuration) {
        this.categoryDuration = categoryDuration;
    }

    public int category(LocalTime value) {
        long category = (long)value.toSecondOfDay() / this.categoryDuration.getSeconds();
        return (int)category;
    }

    public LocalTime minValue(int category) {
        LocalTime minValue = LocalTime.MIDNIGHT.plus(this.categoryDuration.multipliedBy(category));
        return minValue;
    }

    public LocalTime maxValue(int category) {
        LocalTime maxValue = LocalTime.MIDNIGHT.plus(this.categoryDuration.multipliedBy(category + 1)).minusNanos(1L);
        return maxValue;
    }
}

