/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.payments;

import de.rtb.pcon.ui.controllers.reports.payments.SaleReportRowCategory;
import java.time.LocalDate;
import java.time.format.TextStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.threeten.extra.YearQuarter;

class SaleReportRowCategoryYearQuater
extends SaleReportRowCategory {
    private YearQuarter delegate;

    public SaleReportRowCategoryYearQuater(int year, int quarter) {
        this.delegate = YearQuarter.of((int)year, (int)quarter);
    }

    public int compareTo(SaleReportRowCategory o) {
        if (this.getClass().equals(o.getClass())) {
            SaleReportRowCategoryYearQuater other = (SaleReportRowCategoryYearQuater)o;
            return this.delegate.compareTo(other.delegate);
        }
        throw new IllegalStateException("Types " + this.getClass().getName() + " and " + o.getClass().getName() + " are not comparable.");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SaleReportRowCategoryYearQuater other = (SaleReportRowCategoryYearQuater)obj;
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals((Object)other.delegate));
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String toLocaleString(Locale locale) {
        return this.delegate.getYear() + " - " + this.delegate.getQuarter().getDisplayName(TextStyle.SHORT, locale);
    }

    public static Set<SaleReportRowCategory> generateCategoriesBetween(LocalDate from, LocalDate to) {
        TreeSet<SaleReportRowCategory> yearMonths = new TreeSet<SaleReportRowCategory>();
        LocalDate now = from;
        while (now.isBefore(to) || now.isEqual(to)) {
            YearQuarter yq = YearQuarter.from((TemporalAccessor)now);
            yearMonths.add((SaleReportRowCategory)new SaleReportRowCategoryYearQuater(yq.getYear(), yq.getQuarterValue()));
            now = now.plusDays(1L);
        }
        return yearMonths;
    }
}

