/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.logbooks;

import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmLogCatalog;
import de.rtb.pcon.model.PdmLogMessage;
import de.rtb.pcon.repositories.PdmLogCatalogRepository;
import de.rtb.pcon.repositories.PdmLogMessageRepository;
import de.rtb.pcon.ui.data_tables.PdmLogRequest;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class LogbookLogsRepository {
    @Autowired
    private PdmLogMessageRepository logMsgRepo;
    @Autowired
    private PdmLogCatalogRepository catRepo;

    @Transactional(readOnly=true)
    public Slice<PdmLogMessage> findPdmLogs(Collection<Pdm> pdms, PdmLogRequest filter) {
        Collection catalogs = this.loadCatalogs((Collection)filter.getCatalogs());
        PageRequest pageReq = PageRequest.of((int)(filter.getStart() / filter.getLength()), (int)filter.getLength(), (Sort)Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"pdmTime")}));
        Slice logPage = StringUtils.isBlank((CharSequence)filter.getSearch().getValue()) ? this.logMsgRepo.findByPdmInAndCatalogInAndPdmTimeGreaterThanEqualAndPdmTimeLessThan(pdms, catalogs, filter.makeOffsetTimeFrom(), filter.makeOffsetTimeTo(), (Pageable)pageReq) : this.logMsgRepo.findByPdmInAndCatalogInAndTextContainingIgnoreCaseAndAndPdmTimeGreaterThanEqualAndPdmTimeLessThan(pdms, catalogs, filter.getSearch().getValue(), filter.makeOffsetTimeFrom(), filter.makeOffsetTimeTo(), (Pageable)pageReq);
        return logPage;
    }

    public long countPdmLogs(Collection<Pdm> pdms, PdmLogRequest filter) {
        Collection catalogs = this.loadCatalogs((Collection)filter.getCatalogs());
        long count = StringUtils.isBlank((CharSequence)filter.getSearch().getValue()) ? this.logMsgRepo.countByPdmInAndCatalogInAndPdmTimeBetween(pdms, catalogs, filter.makeOffsetTimeFrom(), filter.makeOffsetTimeTo()) : this.logMsgRepo.countByPdmInAndCatalogInAndTextContainingIgnoreCaseAndPdmTimeBetween(pdms, catalogs, filter.getSearch().getValue(), filter.makeOffsetTimeFrom(), filter.makeOffsetTimeTo());
        return count;
    }

    private Collection<PdmLogCatalog> loadCatalogs(Collection<Short> catalogIds) {
        List catalogs = CollectionUtils.isEmpty(catalogIds) ? IterableUtils.toList((Iterable)this.catRepo.findAll()) : IterableUtils.toList((Iterable)this.catRepo.findAllById(catalogIds));
        return catalogs;
    }
}

