/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers;

import de.rtb.pcon.ui.services.I18nService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/pcon/ui/"})
@Deprecated
public class TextController {
    @Autowired
    private I18nService i18n;

    @GetMapping(path={"text/mnr/{numberAndReason}"}, produces={"text/plain"})
    @PreAuthorize(value="isAuthenticated()")
    public String resolveLocalizedNmrText(@PathVariable(value="numberAndReason") String numberAndReason) {
        if (StringUtils.isBlank((CharSequence)numberAndReason)) {
            return "Number (and reason) is not provided.";
        }
        numberAndReason = StringUtils.trim((String)numberAndReason);
        int startOfReason = numberAndReason.length();
        for (int i = 0; i < numberAndReason.length(); ++i) {
            if (Character.isDigit(numberAndReason.charAt(i))) continue;
            startOfReason = i;
            break;
        }
        try {
            String mnrString = StringUtils.substring((String)numberAndReason, (int)0, (int)startOfReason);
            String reason = null;
            if (startOfReason < numberAndReason.length()) {
                reason = StringUtils.substring((String)numberAndReason, (int)startOfReason);
            }
            int mnr = Integer.parseInt(mnrString);
            return this.i18n.getStatusMessageFullText(mnr, reason);
        }
        catch (NumberFormatException e) {
            return numberAndReason;
        }
    }

    @GetMapping(value={"text/mnrs"})
    @PreAuthorize(value="isAuthenticated()")
    public Map<String, String> resolveLocalizedNmrTexts(@RequestParam(value="mnr") List<String> numberAndReasons) {
        HashMap<String, String> result = new HashMap<String, String>();
        numberAndReasons.forEach(mnrGroup -> result.put((String)mnrGroup, this.resolveLocalizedNmrText(mnrGroup)));
        return result;
    }
}

