/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers;

import de.rtb.pcon.core.events.AreaDeletedEvent;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.zone.EnforcementMode;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.repositories.AreaRepository;
import de.rtb.pcon.repositories.UserRepository;
import de.rtb.pcon.repositories.ZoneRepository;
import de.rtb.pcon.ui.controllers.UiAdminArea;
import de.rtb.pcon.ui.controllers.UiAdminAreaDetail;
import de.rtb.pcon.ui.controllers.UiAreaNumberValidationResult;
import de.rtb.pcon.ui.controllers.model.UiAreaProperties;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcontrol.utils.LoggerUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Tuple;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(path={"/api/pcon/ui/admin/areas"})
@PreAuthorize(value="hasRole('ROLE_ADMIN_USERS')")
class AdminAreaController {
    private static final Logger log = LoggerFactory.getLogger(AdminAreaController.class);
    private static final Logger actionLogger = LoggerFactory.getLogger((String)("de.rtb.pcontrol.audit.actions." + AdminAreaController.class.getSimpleName()));
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private SecurityService securityServce;
    @Autowired
    private AreaRepository areaRepo;
    @Autowired
    private ZoneRepository zoneRepo;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private UserRepository userRepo;
    @PersistenceContext
    private EntityManager em;

    AdminAreaController() {
    }

    @GetMapping
    public Collection<UiAdminArea> getAreas() {
        HashSet userAreas = new HashSet(this.securityServce.getCurrentAreas());
        return this.em.createQuery("SELECT   a AS area,   (SELECT count(*) FROM Pdm p JOIN p.zone z WHERE z.area = a) AS pdms,   (SELECT count(*) FROM Zone z WHERE z.area = a) AS zones,   (SELECT count(*) FROM User u WHERE a in elements(u.areas)) AS users FROM Area a ", Tuple.class).getResultList().stream().map(ai -> {
            Area area = (Area)ai.get("area", Area.class);
            return new UiAdminArea(area, ((Long)ai.get("pdms", Long.class)).intValue(), ((Long)ai.get("zones", Long.class)).intValue(), ((Long)ai.get("users", Long.class)).intValue(), userAreas.contains(area));
        }).collect(Collectors.toList());
    }

    @GetMapping(value={"{id}/detail"})
    @Transactional(readOnly=true)
    public UiAdminAreaDetail getAreaDetail(@PathVariable(value="id") Integer areaId) {
        return this.areaRepo.findById((Object)areaId).map(UiAdminAreaDetail::new).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"{id}"})
    @Transactional
    public ResponseEntity<Object> deleteArea(@PathVariable(value="id") int areaId) {
        MutableObject result = new MutableObject();
        User user = this.securityServce.getCurrentUser();
        Optional areaO = this.areaRepo.findById((Object)areaId);
        areaO.ifPresentOrElse(a -> {
            this.transactionTemplate.executeWithoutResult(status -> {
                log.info("Deleting {}", (Object)LoggerUtils.log((Area)a));
                this.areaRepo.delete(a);
                status.flush();
                if (actionLogger.isInfoEnabled()) {
                    actionLogger.info("The {} deleted {}.", (Object)LoggerUtils.log((User)user), (Object)LoggerUtils.log((Area)a));
                }
                log.info("Area {} was deleted.", (Object)areaId);
            });
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new AreaDeletedEvent((Object)this, Integer.valueOf(areaId)));
            result.setValue((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build());
        }, () -> {
            if (actionLogger.isDebugEnabled()) {
                actionLogger.debug("The {} tried to delete area #{} which does not exist.", (Object)LoggerUtils.log((User)user), (Object)areaId);
            }
            result.setValue((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
        });
        return (ResponseEntity)result.getValue();
    }

    @GetMapping(value={"{id}/available"})
    public UiAreaNumberValidationResult validateAreaCode(@PathVariable(value="id") Integer areaId) {
        return new UiAreaNumberValidationResult(this.areaRepo.findById((Object)areaId));
    }

    @PutMapping(value={"{id}"})
    @Transactional
    public UiAreaProperties createArea(@PathVariable(value="id") Integer areaId, @RequestBody UiAreaProperties areaProperties) {
        Optional dbArea = this.areaRepo.findById((Object)areaId);
        if (dbArea.isPresent()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "Area " + areaId + " already exists.");
        }
        User user = (User)this.userRepo.findById((Object)this.securityServce.getCurrentUser().getId()).orElseThrow();
        Area area = new Area();
        area.setId(areaId);
        area.setName(areaProperties.getName());
        area.setTimeZoneName(areaProperties.getTimeZone());
        area = (Area)this.areaRepo.save((Object)area);
        user.getAreas().add(area);
        Zone zone = new Zone();
        zone.setName(areaProperties.getName());
        zone.setColor("#f0f0f0");
        zone.setEnforcementMode(EnforcementMode.DISABLED);
        zone.setIsDefaultZone(Boolean.valueOf(true));
        zone.setArea(area);
        this.zoneRepo.save((Object)zone);
        area.setZones(List.of(zone));
        if (actionLogger.isInfoEnabled()) {
            actionLogger.info("The {} created {},", (Object)LoggerUtils.log((User)user), (Object)LoggerUtils.log((Area)area));
        }
        return new UiAreaProperties(area);
    }
}

