/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.repositories;

import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.PaymentTransactionId_;
import de.rtb.pcon.model.PaymentTransaction_;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.model.Pdm;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Collection;
import org.springframework.data.jpa.domain.Specification;

public class PaymentTransactionSpecification {
    private PaymentTransactionSpecification() {
    }

    public static Specification<PaymentTransaction> pdmIn(Collection<Pdm> pdms) {
        return (Specification & Serializable)(root, query, builder) -> root.get(PaymentTransaction_.id).get(PaymentTransactionId_.pdm).in(pdms);
    }

    public static Specification<PaymentTransaction> between(OffsetDateTime from, OffsetDateTime to) {
        return (Specification & Serializable)(root, query, builder) -> {
            Path time = root.get(PaymentTransaction_.id).get(PaymentTransactionId_.pdmTime);
            return builder.and((Expression)builder.greaterThanOrEqualTo((Expression)time, (Comparable)from), (Expression)builder.lessThan((Expression)time, (Comparable)to));
        };
    }

    public static Specification<PaymentTransaction> paymentReasonIn(Collection<PaymentReason> paymentReasons) {
        return (Specification & Serializable)(root, query, builder) -> root.get(PaymentTransaction_.paymentReason).in(paymentReasons);
    }

    public static Specification<PaymentTransaction> paymentTypeIn(Collection<PaymentType> paymentTypes) {
        return (Specification & Serializable)(root, query, builder) -> root.get(PaymentTransaction_.paymentType).in(paymentTypes);
    }
}

