/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.model.clearing;

import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.model.Pdm;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import org.hibernate.annotations.JdbcType;
import org.hibernate.dialect.PostgreSQLEnumJdbcType;

@Entity
@Table(name="clearing", schema="control")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="clr_class_type", discriminatorType=DiscriminatorType.INTEGER)
@DiscriminatorValue(value="0")
public class Clearing {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="clr_id")
    private Long id;
    @ManyToOne
    @JoinColumn(name="clr_pdm_id")
    private Pdm pdm;
    @Column(name="clr_date_pdm", nullable=false)
    private OffsetDateTime pdmTime;
    @Column(name="clr_date_pc", nullable=false)
    private OffsetDateTime serverTime;
    @Column(name="clr_currency", nullable=false, length=3)
    private String currency;
    @Column(name="clr_clearing_nr")
    private Integer clearingNumber;
    @Column(name="clr_tracer")
    private int tracer;
    @Column(name="clr_asn")
    private Integer asn;
    @Column(name="clr_value")
    private BigDecimal valueSold;
    @Column(name="clr_value_lifelong")
    private BigDecimal valueLifeLong;
    @Column(name="clr_tickets")
    private Integer ticketCount;
    @Column(name="clr_pay_type", columnDefinition="\"control\".\"payment_type\"\n")
    @Enumerated(value=EnumType.STRING)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    private PaymentType paymentType;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Pdm getPdm() {
        return this.pdm;
    }

    public void setPdm(Pdm pdm) {
        this.pdm = pdm;
    }

    public OffsetDateTime getPdmTime() {
        return this.pdmTime;
    }

    public void setPdmTime(OffsetDateTime pdmTime) {
        this.pdmTime = pdmTime;
    }

    public OffsetDateTime getServerTime() {
        return this.serverTime;
    }

    public void setServerTime(OffsetDateTime serverTime) {
        this.serverTime = serverTime;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Integer getClearingNumber() {
        return this.clearingNumber;
    }

    public void setClearingNumber(Integer clearingNumber) {
        this.clearingNumber = clearingNumber;
    }

    public int getTracer() {
        return this.tracer;
    }

    public void setTracer(int tracer) {
        this.tracer = tracer;
    }

    public Integer getAsn() {
        return this.asn;
    }

    public void setAsn(Integer asn) {
        this.asn = asn;
    }

    public BigDecimal getValueSold() {
        return this.valueSold;
    }

    public void setValueSold(BigDecimal valueSold) {
        this.valueSold = valueSold;
    }

    public BigDecimal getValueLifeLong() {
        return this.valueLifeLong;
    }

    public void setValueLifeLong(BigDecimal valueLifeLong) {
        this.valueLifeLong = valueLifeLong;
    }

    public Integer getTicketCount() {
        return this.ticketCount;
    }

    public void setTicketCount(Integer ticketCount) {
        this.ticketCount = ticketCount;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }
}

