/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.model;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name="cash_kind", schema="control", uniqueConstraints={@UniqueConstraint(columnNames={"csk_code", "csk_value"})})
public class CashKind {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="csk_id")
    private Long id;
    @Column(name="csk_code", length=3, nullable=false)
    private String currency;
    @Column(name="csk_value", nullable=false)
    private BigDecimal value;

    public static final CashKind of(BigDecimal value, String currency) {
        CashKind cashKind = new CashKind();
        cashKind.setCurrency(currency);
        cashKind.setValue(value);
        return cashKind;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE);
        tsb.append("id", (Object)this.getId());
        tsb.append((Object)this.getCurrency());
        tsb.append((Object)this.getValue());
        return tsb.toString();
    }
}

