/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.rao;

import de.rtb.pcon.core.integration.BlockingCallGuard;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.rao.RaoConfigDto;
import de.rtb.pcon.features.partners.rao.RaoConfigService;
import de.rtb.pcon.features.partners.rao.RaoProperties;
import de.rtb.pcon.model.Area;
import java.net.URI;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;

@Component
class RaoRtrAbortSale
implements RealTimeRequest {
    @Autowired
    @Qualifier(value="wc3rdPartyApi")
    private RestClient restClient;
    @Autowired
    private BlockingCallGuard blokcingCallGuard;
    @Autowired
    private RaoConfigService raoConfigService;
    @Autowired
    private RaoProperties raoProps;

    RaoRtrAbortSale() {
    }

    public int getId() {
        return 57;
    }

    public String getDescription() {
        return "RAO, abort sale";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        return this.blokcingCallGuard.webCallExecute(() -> this.doWebCall(ctx));
    }

    private Map<String, Object> doWebCall(RealTimeRequestExecutionContext ctx) {
        Area area = ctx.global().getPdm().getZone().getArea();
        RaoConfigDto config = (RaoConfigDto)this.raoConfigService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        Object iniSaleRequest = ctx.getLocalObject("body", Object.class);
        try {
            URI uri = UriComponentsBuilder.fromUriString((String)this.raoProps.getUrl()).pathSegment(new String[]{"pdm", "partner", "rao", "sale", "abort"}).build().toUri();
            Object confirmSateResponse = ((RestClient.RequestBodySpec)this.restClient.post().uri(uri)).body(iniSaleRequest).retrieve().body(Object.class);
            return Map.of("httpStatus", 200, "body", confirmSateResponse);
        }
        catch (RestClientResponseException e) {
            return Map.of("httpStatus", e.getStatusCode().value(), "body", e.getResponseBodyAsString());
        }
        catch (RestClientException e) {
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
    }
}

