/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.features.partners.PartnerConfiguration;
import de.rtb.pcon.features.partners.PartnerConfigurationService;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.AreaPartnerType;
import de.rtb.pcon.repositories.AreaPartnerRepository;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class PartnesConfigurationServiceBase<T extends PartnerConfiguration> {
    protected final AreaPartnerRepository configRepo;
    protected final ObjectMapper objectMapper;
    protected final AreaPartnerType partnerType;
    @Autowired
    private PartnerConfigurationService partnerConfigService;

    protected PartnesConfigurationServiceBase(AreaPartnerType partnerType, AreaPartnerRepository configRepo, ObjectMapper objectMapper) {
        this.partnerType = partnerType;
        this.configRepo = configRepo;
        this.objectMapper = objectMapper;
    }

    public T fetchConfig(Area area) {
        PartnerConfiguration cfg = (PartnerConfiguration)this.partnerConfigService.fetchConfigs(area).get(this.partnerType);
        if (cfg != null) {
            return (T)cfg;
        }
        return (T)this.newDefautlConfig();
    }

    public void updateConfig(Area area, T config) {
        this.partnerConfigService.updateConfig(area, config, this.partnerType);
    }

    public void deleteConfig(Area area, AreaPartnerType partnerType) {
        this.partnerConfigService.deleteConfig(area, partnerType);
    }

    public abstract T newDefautlConfig();
}

