/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.multi_tariff_2;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.bonus.multi_tariff_2.BonMt2RuleDao;
import de.rtb.pcon.features.bonus.multi_tariff_2.BonMt2RuleEntity;
import de.rtb.pcon.features.bonus.multi_tariff_2.BonMt2Service;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.TariffInfo;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcontrol.utils.LoggerUtils;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
class BonMt2RtrOffer
implements RealTimeRequest {
    private static final Logger log = LoggerFactory.getLogger(BonMt2RtrOffer.class);
    @Autowired
    private BonMt2Service mt2Service;

    BonMt2RtrOffer() {
    }

    public int getId() {
        return 25;
    }

    public String getDescription() {
        return "Multi tariff 2, offer";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Pdm pdm = ctx.findPdmEntity();
        String lcn = ctx.getLicensePlate();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("LCN", lcn);
        result.put("TID", 0);
        if (pdm.getZone() == null) {
            result.put("ERC", 5);
            result.put("TID", -1);
            if (log.isWarnEnabled()) {
                log.warn("{} which requested MT2 bonus is not part of any Zone. Bonus is available only for PDM belonging to a Zone.", (Object)StringUtils.capitalize((String)LoggerUtils.log((Pdm)pdm)));
            }
            return result;
        }
        Optional subscriptionO = this.mt2Service.findRule(lcn, pdm);
        if (subscriptionO.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Bonus for '{}' and {} in {} was not found.", new Object[]{lcn, LoggerUtils.log((Pdm)pdm), LoggerUtils.log((Zone)pdm.getZone())});
            }
            return result;
        }
        ZoneId pdmTimeZone = ZoneId.of(pdm.getZone().getArea().getTimeZoneName());
        BonMt2RuleEntity subscription = (BonMt2RuleEntity)subscriptionO.get();
        result.put("subscription", new BonMt2RuleDao((BonMt2RuleEntity)subscriptionO.get(), pdmTimeZone));
        if (OffsetDateTime.now().isAfter(subscription.getValidTo())) {
            if (log.isErrorEnabled()) {
                log.debug("Bonus for '{}' requested by {} in {} is expired (valid to {}).", new Object[]{lcn, LoggerUtils.log((Pdm)pdm), LoggerUtils.log((Zone)pdm.getZone()), subscription.getValidTo()});
            }
            return result;
        }
        if (OffsetDateTime.now().isBefore(subscription.getValidFrom())) {
            if (log.isErrorEnabled()) {
                log.debug("Bonus for '{}' requested by {} in {} is not yet active (valid from {}).", new Object[]{lcn, LoggerUtils.log((Pdm)pdm), LoggerUtils.log((Zone)pdm.getZone()), subscription.getValidFrom()});
            }
            return result;
        }
        Optional lastUsage = this.mt2Service.usedToday(lcn, pdm);
        if (lastUsage.isPresent()) {
            if (log.isErrorEnabled()) {
                log.debug("Bonus for '{}' requested by {} in {} was already used today.", new Object[]{lcn, LoggerUtils.log((Pdm)pdm), LoggerUtils.log((Zone)pdm.getZone())});
            }
            return result;
        }
        result.put("TID", BonMt2RtrOffer.findTariffIndex((List)pdm.getTariffInfos(), (String)subscription.getTariffName()));
        return result;
    }

    public static int findTariffIndex(List<TariffInfo> tariffInfos, String name) {
        for (int i = 0; i < tariffInfos.size(); ++i) {
            TariffInfo ti = tariffInfos.get(i);
            if (ti == null || !name.equals(ti.getName())) continue;
            return i + 1;
        }
        return -1;
    }
}

