/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.multi_tariff_2;

import de.rtb.pcon.core.services.pdm_in.MessageParserHelper;
import de.rtb.pcon.features.bonus.multi_tariff_2.BonMt2RuleEntity;
import de.rtb.pcon.features.bonus.multi_tariff_2.BonMt2RuleRepository;
import de.rtb.pcon.features.bonus.multi_tariff_2.BonMt2RuleUi;
import de.rtb.pcon.features.bonus.multi_tariff_2.BonMt2Service;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.ui.controllers.EntityNotAvailableException;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelImportException;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelProcessingException;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelProcessingUtilsService;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelUploadResult;
import de.rtb.pcontrol.utils.DateTimeUtils;
import de.rtb.pcontrol.utils.ExcelExportHelper;
import de.rtb.pcontrol.utils.ExcelOutputStream;
import de.rtb.pcontrol.utils.LoggerUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(path={"/api/pcon/ui/zones/{id}/bonus/lpn/mt2"})
@PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
class BonMt2Controller {
    private static final Logger logger = LoggerFactory.getLogger(BonMt2Controller.class);
    private static final Logger actionLogger = LoggerFactory.getLogger((String)"de.rtb.pcontrol.audit.actions.");
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private I18nService i18n;
    @Autowired
    private ExcelProcessingUtilsService excelProcessingUtilsService;
    @Autowired
    private SecureEntityLoaderService entityLoader;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private BonMt2Service mt2Service;
    @Autowired
    private BonMt2RuleRepository mt2Repo;

    BonMt2Controller() {
    }

    @ExceptionHandler(value={EntityNotAvailableException.class})
    public ResponseEntity<String> handleEntityLoadException(EntityNotAvailableException ex) {
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)ex.getHttpStatus());
    }

    @ExceptionHandler(value={ExcelProcessingException.class})
    public ResponseEntity<ExcelUploadResult> handleExcelImportException(ExcelProcessingException exWrapper) {
        return this.excelProcessingUtilsService.handleExcelImportException(exWrapper);
    }

    @PostMapping(value={"rules"}, consumes={"multipart/form-data"})
    @Transactional
    public ResponseEntity<ExcelUploadResult> setRules(@PathVariable(value="id") int zoneId, @RequestParam(value="rules") MultipartFile file) {
        Iterator iterator;
        block17: {
            Zone zone = this.entityLoader.loadZone(zoneId);
            logger.info("Uploading data for 'LPN multi-tariff-2' bonus");
            Optional validationResult = this.excelProcessingUtilsService.validateEcxelUpload(file);
            if (validationResult.isPresent()) {
                return (ResponseEntity)validationResult.get();
            }
            User currentUser = this.securityService.getCurrentUser();
            ZoneId userTimeZone = this.i18n.userTimeZoneId();
            Workbook workbook = this.excelProcessingUtilsService.openWorkbookForStreaming(file);
            try {
                logger.info("Importing LPN multi-tariff-2 rules ...");
                int ruleCounter = 0;
                for (Sheet sheet : workbook) {
                    for (Row r : sheet) {
                        Cell cellLpn = r.getCell(0);
                        if (cellLpn == null || !CellType.STRING.equals((Object)cellLpn.getCellType())) {
                            throw new ExcelImportException(sheet.getSheetName(), r.getRowNum(), 0, this.i18n.getLocalizedMessage("document.import.excel.error.cell.lpnMustBeText", new Object[0]));
                        }
                        String valLpn = MessageParserHelper.parseLcn((String)cellLpn.getStringCellValue());
                        Cell cellValidFrom = r.getCell(1);
                        if (cellValidFrom == null || !CellType.NUMERIC.equals((Object)cellValidFrom.getCellType())) {
                            throw new ExcelImportException(sheet.getSheetName(), r.getRowNum(), 1, this.i18n.getLocalizedMessage("document.import.excel.error.cell.date", new Object[0]));
                        }
                        OffsetDateTime valValidFrom = ZonedDateTime.ofInstant(cellValidFrom.getDateCellValue().toInstant(), userTimeZone).toOffsetDateTime().truncatedTo(ChronoUnit.DAYS);
                        Cell cellValidTo = r.getCell(2);
                        if (cellValidTo == null || !CellType.NUMERIC.equals((Object)cellValidTo.getCellType())) {
                            throw new ExcelImportException(sheet.getSheetName(), r.getRowNum(), 2, this.i18n.getLocalizedMessage("document.import.excel.error.cell.date", new Object[0]));
                        }
                        OffsetDateTime valValidto = ZonedDateTime.ofInstant(cellValidTo.getDateCellValue().toInstant(), userTimeZone).toOffsetDateTime().truncatedTo(ChronoUnit.DAYS).plusDays(1L);
                        Cell cellTariffName = r.getCell(3);
                        if (cellTariffName == null || !CellType.STRING.equals((Object)cellTariffName.getCellType())) {
                            throw new ExcelImportException(sheet.getSheetName(), r.getRowNum(), 3, this.i18n.getLocalizedMessage("document.import.excel.error.cell.tariffMustBeText", new Object[0]));
                        }
                        String valTariffName = cellTariffName.getStringCellValue();
                        Cell cellExpiryTolerance = r.getCell(4);
                        if (cellExpiryTolerance == null || !CellType.NUMERIC.equals((Object)cellExpiryTolerance.getCellType())) {
                            throw new ExcelImportException(sheet.getSheetName(), r.getRowNum(), 4, this.i18n.getLocalizedMessage("document.import.excel.error.cell.numeric", new Object[0]));
                        }
                        Integer valExpiryTolerance = (int)Math.round(cellExpiryTolerance.getNumericCellValue());
                        BonMt2RuleEntity mtr = new BonMt2RuleEntity();
                        mtr.setLpn(valLpn);
                        mtr.setValidFrom(valValidFrom);
                        mtr.setValidTo(valValidto);
                        mtr.setTariffName(valTariffName);
                        mtr.setExpiryToleranceInDays(valExpiryTolerance);
                        mtr.setZone(zone);
                        this.mt2Service.upsertRule(mtr);
                        ++ruleCounter;
                    }
                }
                logger.info("Imported {} rules.", (Object)ruleCounter);
                if (actionLogger.isInfoEnabled()) {
                    actionLogger.info("{} has inserted or updated {} 'LPN multi tariff 2 bonus' rules.", (Object)StringUtils.capitalize((String)LoggerUtils.log((User)currentUser)), (Object)ruleCounter);
                }
                iterator = new ResponseEntity((Object)new ExcelUploadResult(ruleCounter, this.i18n.getLocalizedMessage("document.import.sucess", new Object[0])), (HttpStatusCode)HttpStatus.OK);
                if (workbook == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (workbook != null) {
                        try {
                            workbook.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ExcelProcessingException((Throwable)e);
                }
            }
            workbook.close();
        }
        return iterator;
    }

    @DeleteMapping(value={"rules"})
    @Transactional
    public void deleteRules(@PathVariable(value="id") int zoneId) {
        User currentUser;
        Zone zone = this.entityLoader.loadZone(zoneId);
        if (logger.isInfoEnabled()) {
            currentUser = this.securityService.getCurrentUser();
            logger.info("All rules from {} was deleted by {}.", (Object)LoggerUtils.log((Zone)zone), (Object)LoggerUtils.log((User)currentUser));
        }
        if (actionLogger.isInfoEnabled()) {
            currentUser = this.securityService.getCurrentUser();
            actionLogger.info("{} has deleted all rules from {}.", (Object)StringUtils.capitalize((String)LoggerUtils.log((User)currentUser)), (Object)LoggerUtils.log((Zone)zone));
        }
        this.mt2Service.deleteRules(zone);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"download"})
    public void downloadExcel(@PathVariable(value="id") int zoneId, HttpServletResponse response) throws IOException {
        Zone zone = this.entityLoader.loadZone(zoneId);
        ExcelExportHelper.setHttpResponseHeaders((HttpServletResponse)response, (String)this.i18n.getLocalizedMessage("document.export.excel.multiTariff2.fileName", new Object[0]));
        try (ExcelOutputStream eos = new ExcelOutputStream((OutputStream)response.getOutputStream(), true);){
            eos.addSheet(this.i18n.getLocalizedMessage("document.export.excel.multiTariff2.sheetName", new Object[0]));
            String styleDateTimeMin = "dateTimeMin";
            eos.registerDateTimeStyle("dateTimeMin", this.i18n.getLocalizedMessage("excel.format.datetime.short.minutes", new Object[0]));
            eos.writeHeaderRow(new String[]{this.i18n.getLocalizedMessage("comp.table.header.label.licensePlate", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.from", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.to", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.tariff", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.expiryTolerance", new Object[0])});
            try (Stream ruleStream = this.mt2Service.streamRules(zone);){
                ruleStream.forEach(r -> {
                    eos.addRow();
                    eos.writeCell(r.getLpn());
                    eos.writeOffsetlDateTime(r.getValidFrom(), "dateTimeMin");
                    eos.writeOffsetlDateTime(r.getValidTo().minusMinutes(1L), "dateTimeMin");
                    eos.writeCell(r.getTariffName());
                    eos.writeCell((Number)r.getExpiryToleranceInDays());
                    this.entityManager.detach(r);
                });
            }
        }
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"list"})
    public List<BonMt2RuleUi> listRules(@PathVariable(value="id") int zoneId, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="pageNumber", defaultValue="1") Integer pageNr) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        ZoneId userTimeZone = ZoneId.of(this.securityService.getCurrentUser().getTimeZoneName());
        ZoneId pdmTimeZone = ZoneId.of(zone.getArea().getTimeZoneName());
        PageRequest pageRequest = PageRequest.of((int)(pageNr - 1), (int)pageSize);
        return this.mt2Repo.findByZoneOrderByLpn(zone, (Pageable)pageRequest).stream().map(r -> new BonMt2RuleUi(r, userTimeZone, pdmTimeZone)).toList();
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"rules/{ruleId}"})
    public BonMt2RuleUi getRule(@PathVariable(value="id") int zoneId, @PathVariable(value="ruleId") int ruleId) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        ZoneId userTimeZone = ZoneId.of(this.securityService.getCurrentUser().getTimeZoneName());
        ZoneId pdmTimeZone = ZoneId.of(zone.getArea().getTimeZoneName());
        return this.mt2Repo.findByZoneAndId(zone, ruleId).map(r -> new BonMt2RuleUi(r, userTimeZone, pdmTimeZone)).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @Transactional(readOnly=false)
    @PutMapping(value={"rules"})
    public BonMt2RuleUi setRule(@PathVariable(value="id") int zoneId, @RequestBody BonMt2RuleUi rule) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        ZoneId userTimeZone = ZoneId.of(this.securityService.getCurrentUser().getTimeZoneName());
        ZoneId pdmTimeZone = ZoneId.of(zone.getArea().getTimeZoneName());
        BonMt2RuleEntity entity = null;
        if (rule.getId() == null || rule.getId() == 0) {
            entity = new BonMt2RuleEntity();
            entity.setZone(zone);
            String safeLpn = MessageParserHelper.parseLcn((String)rule.getLpn());
            entity.setLpn(safeLpn);
        } else {
            entity = (BonMt2RuleEntity)this.mt2Repo.findByZoneAndId(zone, rule.getId().intValue()).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
        }
        entity.setTariffName(rule.getTariff());
        entity.setValidFrom(DateTimeUtils.toOffsetDateTime((LocalDateTime)rule.getFrom(), (ZoneId)userTimeZone));
        entity.setValidTo(DateTimeUtils.toOffsetDateTime((LocalDateTime)rule.getTo(), (ZoneId)userTimeZone));
        entity.setExpiryToleranceInDays(Optional.ofNullable(rule.getRenew()).orElse(0));
        this.mt2Repo.save((Object)entity);
        return new BonMt2RuleUi(entity, userTimeZone, pdmTimeZone);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"count"})
    public int countRules(@PathVariable(value="id") int zoneId) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        return this.mt2Repo.countByZone(zone);
    }

    @GetMapping(value={"lpnInfo"})
    public Object lpnInfo(@PathVariable(value="id") int zoneId, @RequestParam(value="lpn") String lpn) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        String safeLpn = MessageParserHelper.parseLcn((String)lpn);
        return Map.of("free", this.mt2Repo.findByLpnAndZone(safeLpn, zone).isEmpty());
    }
}

