/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.gates;

import de.rtb.pcon.features.bonus.gates.PresentTicketEntity;
import de.rtb.pcon.features.bonus.gates.PresentTicketRepository;
import de.rtb.pcon.features.bonus.gates.UiActiveTicket;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import de.rtb.pcon.ui.services.SecurityService;
import java.time.ZoneId;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(path={"/api/pcon/ui/zones/{zoneId}/bonus/gate"})
@PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
class BonGateController {
    @Autowired
    private PresentTicketRepository activeTicketRepo;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private SecureEntityLoaderService entityLoader;

    BonGateController() {
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"count"})
    public Integer countActive(@PathVariable(value="zoneId") Integer zoneId) {
        Zone zone = this.entityLoader.loadZone(zoneId.intValue());
        return this.activeTicketRepo.countByZone(zone);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"active"})
    public List<UiActiveTicket> listActive(@PathVariable(value="zoneId") Integer zoneId, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="pageNumber", defaultValue="1") Integer pageNr) {
        Zone zone = this.entityLoader.loadZone(zoneId.intValue());
        ZoneId timeZone = ZoneId.of(zone.getArea().getTimeZoneName());
        PageRequest page = PageRequest.of((int)(pageNr - 1), (int)pageSize);
        return this.activeTicketRepo.findByZoneOrderByArrivalDescTicketNumberDesc(zone, (Pageable)page).stream().map(t -> UiActiveTicket.fromEntity((PresentTicketEntity)t, (ZoneId)timeZone)).toList();
    }

    @Transactional
    @DeleteMapping(value={"active/{ticketId}"})
    public void deleteActiveById(@PathVariable(value="ticketId") Integer ticketId) {
        PresentTicketEntity ticket = (PresentTicketEntity)this.activeTicketRepo.findById((Object)ticketId).orElseThrow();
        if (this.securityService.deniedFor(ticket.getZone())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        this.activeTicketRepo.delete((Object)ticket);
    }

    @Transactional
    @PutMapping(value={"{ticketId}/setFlags"})
    public void setFlags(@PathVariable(value="ticketId") Integer ticketId, @RequestBody List<String> flags) {
        PresentTicketEntity ticket = (PresentTicketEntity)this.activeTicketRepo.findById((Object)ticketId).orElseThrow();
        if (this.securityService.deniedFor(ticket.getZone())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        List<String> enabledFlagsFiltered = flags.stream().filter(f -> ticket.getFlagsAllowed().contains(f)).toList();
        ticket.setFlagsEnabled(enabledFlagsFiltered);
    }
}

