/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.disposable;

import de.rtb.pcon.db.converter.MinuteDurationConverter;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.zone.Zone;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.OffsetDateTime;

@Entity
@Table(name="bonus_disposable", schema="control", uniqueConstraints={@UniqueConstraint(columnNames={"code", "zone_id"})})
class BonDisRuleEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Integer id;
    @Column(name="code")
    private String code;
    @Column(name="duration")
    @Convert(converter=MinuteDurationConverter.class)
    private Duration duration;
    @Column(name="discount")
    private BigDecimal discount;
    @Column(name="tariff_name")
    private String tariff;
    @Column(name="valid_from")
    private OffsetDateTime validFrom;
    @Column(name="valid_to")
    private OffsetDateTime validTo;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="pay_pdm_id"), @JoinColumn(name="pay_ts")})
    private PaymentTransaction consumer;
    @ManyToOne
    @JoinColumn(name="creator_id")
    private User creator;
    @Column(name="created")
    private OffsetDateTime created;
    @ManyToOne
    @JoinColumn(name="zone_id")
    private Zone zone;

    BonDisRuleEntity() {
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration time) {
        this.duration = time;
    }

    public BigDecimal getDiscount() {
        return this.discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public String getTariff() {
        return this.tariff;
    }

    public void setTariff(String tariff) {
        this.tariff = tariff;
    }

    public OffsetDateTime getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(OffsetDateTime validFrom) {
        this.validFrom = validFrom;
    }

    public OffsetDateTime getValidTo() {
        return this.validTo;
    }

    public void setValidTo(OffsetDateTime validTo) {
        this.validTo = validTo;
    }

    public PaymentTransaction getConsumer() {
        return this.consumer;
    }

    public void setConsumer(PaymentTransaction consumer) {
        this.consumer = consumer;
    }

    public User getCreator() {
        return this.creator;
    }

    public void setCreator(User creator) {
        this.creator = creator;
    }

    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public Zone getZone() {
        return this.zone;
    }

    public void setZone(Zone zone) {
        this.zone = zone;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BonDisRuleEntity other = (BonDisRuleEntity)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

