/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.cumulative_time;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.bonus.cumulative_time.BonCumulativeTimeEntity;
import de.rtb.pcon.features.bonus.cumulative_time.BonCumulativeTimePaymentRepository;
import de.rtb.pcon.features.bonus.cumulative_time.BonCumulativeTimeRepository;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.zone.Zone;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
class BonCumulativeTimeListRtr
implements RealTimeRequest {
    @Autowired
    private BonCumulativeTimePaymentRepository paymentRepo;
    @Autowired
    private BonCumulativeTimeRepository configRepo;
    private CronParser cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));

    public int getId() {
        return 41;
    }

    public String getDescription() {
        return "Cumulative time";
    }

    @Transactional
    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Zone zone = ctx.global().getPdm().getZone();
        ZoneId pdmTimeZone = ZoneId.of(zone.getArea().getTimeZoneName());
        Optional cfgO = this.configRepo.findByZone(zone);
        boolean bonusEnabled = cfgO.map(BonCumulativeTimeEntity::getEnabled).orElse(false);
        if (!bonusEnabled) {
            return Map.of("enabled", false);
        }
        BonCumulativeTimeEntity cfg = (BonCumulativeTimeEntity)cfgO.get();
        String lpn = ctx.getLicensePlate();
        int curScale = ctx.getMonetaryScale();
        ZonedDateTime now = ZonedDateTime.now(pdmTimeZone);
        ExecutionTime execTime = ExecutionTime.forCron((Cron)this.cronParser.parse(cfg.getRenewCron()));
        ZonedDateTime lastReset = (ZonedDateTime)execTime.lastExecution(now).get();
        List paymetns = this.paymentRepo.findByIdPdmZoneAndLpnAndIdPdmTimeAfter(zone, lpn, lastReset.toOffsetDateTime());
        long sumTime = this.sumMinutes(paymetns);
        Map<String, Integer> sumPrice = this.sumPrice(paymetns).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((BigDecimal)e.getValue()).scaleByPowerOfTen(curScale).intValue()));
        int sumCount = paymetns.size();
        return Map.of("enabled", true, "time", sumTime, "price", sumPrice, "count", sumCount);
    }

    int sumMinutes(List<PaymentTransaction> payments) {
        Duration sumTime = payments.stream().map(pt -> Duration.between(pt.getId().getPdmTime().truncatedTo(ChronoUnit.MINUTES), pt.getParkEndTime())).reduce(Duration.ZERO, (sum, curr) -> sum.plus((Duration)curr));
        return (int)sumTime.toMinutes();
    }

    Map<String, BigDecimal> sumPrice(List<PaymentTransaction> payments) {
        return payments.stream().collect(Collectors.toMap(PaymentTransaction::getCurrency, PaymentTransaction::getAmount, BigDecimal::add));
    }
}

