/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.counter1;

import de.rtb.pcon.features.bonus.counter1.BonCounter1DaoCounter;
import de.rtb.pcon.features.bonus.counter1.BonCounter1RuleEntity;
import de.rtb.pcon.features.bonus.counter1.BonCounter1RuleRepository;
import de.rtb.pcon.features.bonus.counter1.BonCounter1UsageEntity;
import de.rtb.pcon.features.bonus.counter1.BonCounter1UsageRepository;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcontrol.utils.LoggerUtils;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.server.ResponseStatusException;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
class BonCounter1Service {
    private static final Logger log = LoggerFactory.getLogger(BonCounter1Service.class);
    private static final Logger actionLogger = LoggerFactory.getLogger((String)"de.rtb.pcontrol.audit.actions.BonusCounter1");
    @Autowired
    private BonCounter1RuleRepository ruleRepo;
    @Autowired
    private BonCounter1UsageRepository usageRepo;
    @Autowired
    private SecurityService securityService;

    BonCounter1Service() {
    }

    @Transactional(readOnly=true)
    public List<BonCounter1DaoCounter> listCountersToday(Zone zone) {
        return this.ruleRepo.findAllByZoneWithUsageByDate(zone, BonCounter1Service.todaysDate((Zone)zone)).stream().map(t -> {
            BonCounter1RuleEntity r = (BonCounter1RuleEntity)t.get(0, BonCounter1RuleEntity.class);
            Integer currentValue = Optional.ofNullable((Integer)t.get(1, Integer.class)).orElse(0);
            return new BonCounter1DaoCounter(Integer.valueOf(r.getId()), r.getName(), r.getMax(), currentValue);
        }).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public BonCounter1DaoCounter getCounterById(Integer counterId, Zone zone) {
        return this.listCountersToday(zone).stream().filter(r -> r.getId().equals(counterId)).findAny().orElseThrow(BonCounter1Service::ruleNotAccessibleException);
    }

    @Transactional
    public BonCounter1DaoCounter addCounter(String counterName, int maxValue, Zone zone) {
        if (this.ruleRepo.findByNameAndZone(counterName, zone).isPresent()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "Counter name already exist");
        }
        BonCounter1RuleEntity cre = new BonCounter1RuleEntity();
        cre.setName(counterName);
        cre.setMax(Integer.valueOf(maxValue));
        cre.setZone(zone);
        return new BonCounter1DaoCounter((BonCounter1RuleEntity)this.ruleRepo.save((Object)cre), Integer.valueOf(0));
    }

    @Transactional
    public boolean deleteCounterById(Integer counterId, Zone zone) {
        Optional counterRule = this.ruleRepo.findById((Object)counterId);
        if (counterRule.isEmpty()) {
            return false;
        }
        BonCounter1RuleEntity rule = (BonCounter1RuleEntity)counterRule.get();
        if (!Objects.equals(rule.getZone(), zone)) {
            return false;
        }
        this.ruleRepo.delete((Object)rule);
        return true;
    }

    @Transactional
    public void updateRule(Integer ruleId, String counterName, Integer maxValue, Zone zone) {
        if (this.ruleRepo.findByNameAndZoneAndIdNot(counterName, zone, ruleId).isPresent()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "Counter name already exist");
        }
        BonCounter1RuleEntity rule = (BonCounter1RuleEntity)this.ruleRepo.findByIdAndZone(ruleId, zone).orElseThrow(BonCounter1Service::ruleNotAccessibleException);
        rule.setName(counterName);
        rule.setMax(maxValue);
    }

    @Transactional(readOnly=true)
    public BonCounter1RuleEntity findRuleById(int ruleId, Zone zone) {
        return (BonCounter1RuleEntity)this.ruleRepo.findByIdAndZone(Integer.valueOf(ruleId), zone).orElseThrow(BonCounter1Service::ruleNotAccessibleException);
    }

    @Transactional
    public void setCounterValue(Integer ruleId, Integer value, Zone zone) {
        BonCounter1RuleEntity rule = this.findRuleById(ruleId.intValue(), zone);
        LocalDate todaysDate = BonCounter1Service.todaysDate((Zone)rule.getZone());
        BonCounter1UsageEntity usage = this.usageRepo.findByRuleAndDate(rule, todaysDate).orElseGet(() -> this.createNewUsageEntity(rule, todaysDate));
        usage.setCurrent(value);
        if (actionLogger.isInfoEnabled()) {
            User user = this.securityService.getCurrentUser();
            actionLogger.info("{} set value of counter '{}' in {} to {}.", new Object[]{StringUtils.capitalize((String)LoggerUtils.log((User)user)), rule.getName(), LoggerUtils.log((Zone)zone), value});
        }
    }

    @Transactional
    public BonCounter1DaoCounter incrementeCounterValue(String name, int increment, Zone zone) {
        Optional ruleO = this.ruleRepo.findByNameAndZone(name, zone);
        if (ruleO.isPresent()) {
            BonCounter1RuleEntity rule = (BonCounter1RuleEntity)ruleO.get();
            LocalDate todaysDate = BonCounter1Service.todaysDate((Zone)rule.getZone());
            BonCounter1UsageEntity usage = this.usageRepo.findByRuleAndDate(rule, todaysDate).orElseGet(() -> this.createNewUsageEntity(rule, todaysDate));
            usage.setCurrent(Integer.valueOf(usage.getCurrent() + increment));
            return new BonCounter1DaoCounter(Integer.valueOf(rule.getId()), rule.getName(), rule.getMax(), usage.getCurrent());
        }
        return new BonCounter1DaoCounter(null, name, Integer.valueOf(-1), Integer.valueOf(-1));
    }

    @Scheduled(cron="0 16 3 * * SAT")
    @Transactional
    public void cleanup() {
        LocalDate dateToCleanEnd = LocalDate.now().minusDays(7L);
        int deletedUsages = this.usageRepo.deleteByDateBefore(dateToCleanEnd);
        log.info("Cleaned up bonus 'counter 1'. Deleted {} usages.", (Object)deletedUsages);
    }

    private static LocalDate todaysDate(Zone zone) {
        return ZonedDateTime.now(ZoneId.of(zone.getArea().getTimeZoneName())).toLocalDate();
    }

    public static final ResponseStatusException ruleNotAccessibleException() {
        return new ResponseStatusException((HttpStatusCode)HttpStatus.NO_CONTENT, "Counting rule either does not exist or it is not accessible.");
    }

    private BonCounter1UsageEntity createNewUsageEntity(BonCounter1RuleEntity rule, LocalDate todaysDate) {
        BonCounter1UsageEntity u = new BonCounter1UsageEntity();
        u.setRule(rule);
        u.setDate(todaysDate);
        u.setCurrent(Integer.valueOf(0));
        return (BonCounter1UsageEntity)this.usageRepo.save((Object)u);
    }
}

