/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.counter1;

import de.rtb.pcon.features.bonus.counter1.BonCounter1DaoCounter;
import de.rtb.pcon.features.bonus.counter1.BonCounter1DaoCounterValue;
import de.rtb.pcon.features.bonus.counter1.BonCounter1Service;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.ui.controllers.EntityNotAvailableException;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/pcon/ui/zones/{zid}/bonus/counting"})
@PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
class BonCounter1Controller {
    @Autowired
    private SecureEntityLoaderService entityLoader;
    @Autowired
    private BonCounter1Service bonusService;

    BonCounter1Controller() {
    }

    @ExceptionHandler(value={EntityNotAvailableException.class})
    public ResponseEntity<String> handleEntityLoadException(EntityNotAvailableException ex) {
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)ex.getHttpStatus());
    }

    @GetMapping
    @Transactional(readOnly=true)
    public List<BonCounter1DaoCounter> listCounters(@PathVariable(value="zid") Integer zoneId) {
        Zone zone = this.entityLoader.loadZone(zoneId.intValue());
        return this.bonusService.listCountersToday(zone);
    }

    @GetMapping(value={"{cid}"})
    @Transactional(readOnly=true)
    public BonCounter1DaoCounter getCounter(@PathVariable(value="zid") Integer zoneId, @PathVariable(value="cid") Integer counterId) {
        Zone zone = this.entityLoader.loadZone(zoneId.intValue());
        return this.bonusService.getCounterById(counterId, zone);
    }

    @DeleteMapping(value={"{cid}"})
    @Transactional
    public void deleteCounter(@PathVariable(value="zid") Integer zoneId, @PathVariable(value="cid") Integer counterId) {
        Zone zone = this.entityLoader.loadZone(zoneId.intValue());
        this.bonusService.deleteCounterById(counterId, zone);
    }

    @PostMapping
    @Transactional
    public BonCounter1DaoCounter addCounter(@PathVariable(value="zid") Integer zoneId, @RequestBody BonCounter1DaoCounter uiCounter) {
        Zone zone = this.entityLoader.loadZone(zoneId.intValue());
        return this.bonusService.addCounter(uiCounter.getName(), uiCounter.getMax().intValue(), zone);
    }

    @PutMapping
    @Transactional
    public BonCounter1DaoCounter updateCounter(@PathVariable(value="zid") Integer zoneId, @RequestBody BonCounter1DaoCounter uiCounter) {
        Zone zone = this.entityLoader.loadZone(zoneId.intValue());
        this.bonusService.updateRule(uiCounter.getId(), uiCounter.getName(), uiCounter.getMax(), zone);
        return this.bonusService.getCounterById(uiCounter.getId(), zone);
    }

    @PutMapping(value={"set-value"})
    @Transactional
    public void setCounter(@PathVariable(value="zid") Integer zoneId, @RequestBody BonCounter1DaoCounterValue counterValue) {
        Zone zone = this.entityLoader.loadZone(zoneId.intValue());
        this.bonusService.setCounterValue(counterValue.getId(), counterValue.getValue(), zone);
    }
}

