/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.user_data;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionException;
import de.rtb.pcon.core.user_data.OpenMode;
import de.rtb.pcon.core.user_data.TransferEncoding;
import de.rtb.pcon.core.user_data.TransferStatus;
import de.rtb.pcon.core.user_data.UserDataFileEntity;
import de.rtb.pcon.core.user_data.UserDataFileName;
import de.rtb.pcon.core.user_data.UserDataFileRecieveRtr;
import de.rtb.pcon.core.user_data.UserDataFileRepositoty;
import de.rtb.pcon.core.user_data.UserDataTransferRequestDto;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcontrol.utils.LoggerUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.hibernate.engine.jdbc.BlobProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
class UserDataFileRecieveRtr
implements RealTimeRequest {
    private static final Logger log = LoggerFactory.getLogger(UserDataFileRecieveRtr.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private UserDataFileRepositoty userDataFileRepo;

    UserDataFileRecieveRtr() {
    }

    public int getId() {
        return 30;
    }

    public String getDescription() {
        return "User data part";
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            UserDataTransferRequestDto msg = (UserDataTransferRequestDto)ctx.mapLocalToObject(UserDataTransferRequestDto.class);
            Pdm pdm = ctx.findPdmEntity();
            if (msg.transferStatus() == TransferStatus.ABORT_ALL) {
                log.info("Requested general abort. All running transfers are canceled.");
                this.userDataFileRepo.findByPdmAndTransferStatusNot(pdm, TransferStatus.IN_PROGRESS).forEach(entity -> this.finishTransfer(entity, TransferStatus.ABORT_ALL));
                return Map.of();
            }
            this.validatePdmMessage(msg);
            UserDataFileEntity fileEntry = this.providePersitentUserDataFileEntity(pdm, msg.fileName());
            if (fileEntry.isCanceled()) {
                result.put("abort", 2);
            }
            result.putAll(this.validatePartNumber(fileEntry, msg));
            ZoneId timeZone = ZoneId.of(pdm.getZone().getArea().getTimeZoneName());
            this.updateDataEntity(fileEntry, msg, timeZone);
            if (msg.transferStatus() != TransferStatus.IN_PROGRESS) {
                this.finishTransfer(fileEntry, msg.transferStatus());
                log.info("User file {}/{} (#{}) was successfully downloaded.", new Object[]{fileEntry.getGroup(), fileEntry.getName(), fileEntry.getId()});
            }
            if (fileEntry.getId() == null) {
                this.userDataFileRepo.save((Object)fileEntry);
            }
        }
        catch (RealTimeRequestExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RealTimeRequestExecutionException(Map.of("abort", 1), "Failed to process file transfer upload request", (Throwable)e);
        }
        return result;
    }

    private void validatePdmMessage(UserDataTransferRequestDto pdmDto) {
        if (pdmDto.fileName() == null) {
            throw new RealTimeRequestExecutionException(Map.of("abort", 1), "Name of the file to store user data to must be provided.");
        }
    }

    private Map<String, Object> validatePartNumber(UserDataFileEntity fileEntry, UserDataTransferRequestDto msg) {
        int expectedPartNumber;
        if (fileEntry.getTransferStatus() != TransferStatus.IN_PROGRESS) {
            log.error("Data transfer #{} is already closed. It can not be modified any more.", (Object)fileEntry.getId());
            throw new RealTimeRequestExecutionException(Map.of("abort", 3), "Data transfer is already closed.");
        }
        switch (1.$SwitchMap$de$rtb$pcon$core$user_data$OpenMode[msg.openMode().ordinal()]) {
            default: {
                throw new MatchException(null, null);
            }
            case 1: {
                int n = 1;
                break;
            }
            case 2: {
                int n = expectedPartNumber = fileEntry.getPartsReceived() + 1;
            }
        }
        if (expectedPartNumber != msg.partNumber()) {
            if (log.isErrorEnabled()) {
                switch (1.$SwitchMap$de$rtb$pcon$core$user_data$OpenMode[msg.openMode().ordinal()]) {
                    case 1: {
                        log.error("Received unexpected part {}. In case of mode {} must be part number '1'.", (Object)msg.partNumber(), (Object)OpenMode.CREATE);
                        break;
                    }
                    case 2: {
                        log.error("Received unexpected part {} instead of {}.", (Object)msg.partNumber(), (Object)expectedPartNumber);
                    }
                }
            }
            throw new RealTimeRequestExecutionException(Map.of("abort", 4, "next", expectedPartNumber));
        }
        return Map.of("next", expectedPartNumber + 1);
    }

    private void updateDataEntity(UserDataFileEntity fileEntry, UserDataTransferRequestDto msg, ZoneId timeZone) {
        msg.contentType().ifPresent(arg_0 -> ((UserDataFileEntity)fileEntry).setContentType(arg_0));
        msg.fileCreationTime().map(t -> ZonedDateTime.of(t, timeZone).toOffsetDateTime()).ifPresent(arg_0 -> ((UserDataFileEntity)fileEntry).setCreatedPdm(arg_0));
        msg.fileSize().ifPresent(arg_0 -> ((UserDataFileEntity)fileEntry).setSizeAnounced(arg_0));
        msg.partsTotal().ifPresent(arg_0 -> ((UserDataFileEntity)fileEntry).setPartsAnounced(arg_0));
        fileEntry.setPartsReceived(msg.partNumber());
        Optional<byte[]> data = msg.encodedData().map(d -> UserDataFileRecieveRtr.decodeData((String)d, (TransferEncoding)msg.transferEncoding()));
        try {
            if (fileEntry.getData() == null) {
                fileEntry.setData(BlobProxy.generateProxy((byte[])data.orElse(ArrayUtils.EMPTY_BYTE_ARRAY)));
                fileEntry.setSizeReceived(data.map(d -> ((byte[])d).length).orElse(0));
                fileEntry.setPartsReceived(msg.partNumber());
            } else {
                if (msg.openMode() == OpenMode.CREATE) {
                    fileEntry.getData().truncate(0L);
                    fileEntry.setSizeReceived(Integer.valueOf(0));
                }
                if (data.isPresent()) {
                    Blob blob = fileEntry.getData();
                    long writeStart = blob.length() + 1L;
                    blob.setBytes(writeStart, data.get());
                    fileEntry.setSizeReceived(Integer.valueOf(fileEntry.getSizeReceived() + data.get().length));
                }
            }
            if (msg.transferStatus() != TransferStatus.IN_PROGRESS) {
                int realDataLenght = (int)fileEntry.getData().length();
                fileEntry.setSizeReceived(Integer.valueOf(realDataLenght));
                log.info("User file {}/{} (#{}) was successfully downloaded.", new Object[]{fileEntry.getGroup(), fileEntry.getName(), fileEntry.getId()});
            }
            fileEntry.setTransferStatus(msg.transferStatus());
        }
        catch (SQLException e) {
            throw new RealTimeRequestExecutionException(Map.of("abort", 1), (Throwable)e);
        }
    }

    private void finishTransfer(UserDataFileEntity entity, TransferStatus transferStatus) {
        try {
            entity.setTransferStatus(transferStatus);
            if (entity.getData() != null) {
                int realDataLenght = (int)entity.getData().length();
                entity.setSizeReceived(Integer.valueOf(realDataLenght));
            } else {
                entity.setData(BlobProxy.generateProxy((byte[])ArrayUtils.EMPTY_BYTE_ARRAY));
                entity.setSizeReceived(Integer.valueOf(0));
            }
        }
        catch (SQLException e) {
            throw new RealTimeRequestExecutionException(Map.of("abort", 1), (Throwable)e);
        }
    }

    private static byte[] decodeData(String data, TransferEncoding encoding) {
        try {
            return switch (1.$SwitchMap$de$rtb$pcon$core$user_data$TransferEncoding[encoding.ordinal()]) {
                default -> throw new MatchException(null, null);
                case 1 -> Base64.getUrlDecoder().decode(data);
                case 2 -> data.getBytes(StandardCharsets.UTF_8);
            };
        }
        catch (IllegalArgumentException e) {
            throw new RealTimeRequestExecutionException(Map.of("abort", 5), String.format("Payload encoding '%s' is not supported.", encoding.toString()));
        }
    }

    OffsetDateTime parseDateTimeDefaultNow(String isoDateTime, String timeZone) {
        Objects.requireNonNull(timeZone, "Time zone of PMD must not be null");
        try {
            return ZonedDateTime.of(LocalDateTime.parse(isoDateTime), ZoneId.of(timeZone)).toOffsetDateTime();
        }
        catch (DateTimeParseException e) {
            log.warn("File creation time '{}' cannot be parsed. Using now() instead.", (Object)isoDateTime);
            return OffsetDateTime.now();
        }
    }

    private UserDataFileEntity providePersitentUserDataFileEntity(Pdm pdm, String fileName) {
        UserDataFileName fn = UserDataFileName.fromString((String)fileName);
        return this.userDataFileRepo.findByPdmAndGroupAndName(pdm, fn.group(), fn.name()).orElseGet(() -> UserDataFileRecieveRtr.createUserData((Pdm)pdm, (UserDataFileName)fn));
    }

    private static final UserDataFileEntity createUserData(Pdm pdm, UserDataFileName fileName) {
        UserDataFileEntity ent = new UserDataFileEntity();
        ent.setPdm(pdm);
        ent.setGroup(fileName.group());
        ent.setName(fileName.name());
        ent.setContentType("application/octet-stream");
        ent.setCreatedPdm(OffsetDateTime.now());
        ent.setCreatedSrv(OffsetDateTime.now());
        ent.setSizeReceived(Integer.valueOf(0));
        ent.setPartsReceived(Integer.valueOf(0));
        ent.setCanceled(false);
        ent.setTransferStatus(TransferStatus.IN_PROGRESS);
        if (log.isDebugEnabled()) {
            log.debug("Created new file entry '{}' for {}", (Object)fileName.groupAndName(), (Object)LoggerUtils.log((Pdm)pdm));
        }
        return ent;
    }
}

