/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.trc_check;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TracerGuard {
    private static final Logger log = LoggerFactory.getLogger(TracerGuard.class);
    private volatile int lastPayment;
    private volatile int lastStatus;
    private volatile int lastClearing;
    private volatile int lastSystem;
    private boolean disableTrcCheck = false;

    public TracerGuard(int payment, int status, int clearing, int system) {
        this(payment, status, clearing, system, false);
    }

    public TracerGuard(int payment, int status, int clearing, int system, boolean disableTrcCheck) {
        this.lastPayment = payment;
        this.lastStatus = status;
        this.lastClearing = clearing;
        this.lastSystem = system;
        this.disableTrcCheck = disableTrcCheck;
    }

    public synchronized boolean allowPayment(int pdmTracer) {
        boolean result = this.isTrcAcceptable(pdmTracer, this.lastPayment, "payment");
        this.lastPayment = pdmTracer;
        return result;
    }

    public synchronized boolean allowStatus(int pdmTracer) {
        boolean result = this.isTrcAcceptable(pdmTracer, this.lastStatus, "status");
        this.lastStatus = pdmTracer;
        return result;
    }

    public synchronized boolean allowClearing(int pdmTracer) {
        boolean result = this.isTrcAcceptable(pdmTracer, this.lastClearing, "clearing");
        this.lastClearing = pdmTracer;
        return result;
    }

    public synchronized boolean allowSystem(int pdmTracer) {
        boolean result = this.isTrcAcceptable(pdmTracer, this.lastSystem, "system");
        this.lastSystem = pdmTracer;
        return result;
    }

    private boolean isTrcAcceptable(int trcPdm, int trcLast, String logMessageType) {
        int expectedTrc = trcLast + 1;
        if (Integer.compareUnsigned(trcPdm, expectedTrc) == 0) {
            return true;
        }
        if (Integer.compareUnsigned(trcPdm, trcLast) == 0) {
            if (this.disableTrcCheck) {
                log.debug("Rejection of {} message with TRC {} was suppressed because of configuration.", (Object)logMessageType, (Object)trcPdm);
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug("{} message with TRC {} is ignored because it has been already received.", (Object)StringUtils.capitalize((String)logMessageType), (Object)trcPdm);
            }
            return false;
        }
        if (expectedTrc > 0 && log.isWarnEnabled()) {
            String diff = String.format("%+d", trcPdm - expectedTrc);
            log.warn("A tracer of {} message is broken. Expected {} but received {} ({}).", new Object[]{logMessageType, expectedTrc, trcPdm, diff});
        }
        return true;
    }
}

