/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.services.pdm_in;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.pdm.msg.json.device_report.DeviceReport;
import de.rtb.pcon.core.real_time_request.RealTimeRequestRegisterService;
import de.rtb.pcontrol.utils.DateTimeFormats;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class MessageParserHelper {
    static final Logger logger = LoggerFactory.getLogger(MessageParserHelper.class);
    public static final Pattern PATTERN_ONLY_ZEROES = Pattern.compile("^0+$");
    public static final Pattern IGNORED_LCN_CHARS = Pattern.compile("[\\p{Punct}\\p{Space}\u00a7]");
    public static final Pattern BANK_CARD_NUMBER = Pattern.compile("(\\d*)[#xX\\s\\*]+(\\d*)");
    public static final Pattern BANK_CARD_ARTIFICIAL_NUMBER = Pattern.compile("(\\d{4})0{12}");
    public static final Pattern CHIP_CARD_NUMBER = Pattern.compile("0*([\\dA-F]+)");
    public static final Pattern MIFARE_CARD_NUMBER = Pattern.compile("[0-9a-f]{14}");
    private final ObjectMapper pdmObjectMapper;

    public MessageParserHelper(@Qualifier(value="pdmObjectMapper") ObjectMapper unquotedJsonMapper) {
        this.pdmObjectMapper = unquotedJsonMapper;
    }

    public static Map<String, String> tokenizeMenmonics(String msg) {
        String[] parts = StringUtils.split((String)msg, (String)";");
        HashMap<String, String> result = new HashMap<String, String>(parts.length);
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            String mnemonic = part.substring(0, 3);
            String value = part.substring(3);
            value = URLDecoder.decode(value, StandardCharsets.UTF_8);
            result.put(mnemonic, value);
        }
        return result;
    }

    public static final String trimText(String text) {
        if (text != null) {
            return text.trim();
        }
        return null;
    }

    public static final String parseLcn(String text) {
        if (text == null) {
            return null;
        }
        if ("NULL".equals(text)) {
            return null;
        }
        String rawLcn = IGNORED_LCN_CHARS.matcher(text).replaceAll("").toUpperCase(Locale.ROOT);
        return StringUtils.isBlank((CharSequence)rawLcn) ? null : rawLcn;
    }

    public static final Float parseScaledFloat(Integer scaledValue, int numberOfDecimalPlaces) {
        if (scaledValue != null) {
            return Float.valueOf((float)((double)scaledValue.intValue() / Math.pow(10.0, numberOfDecimalPlaces)));
        }
        return null;
    }

    public static final Integer parseIntHex(String text) {
        if (text != null) {
            return Integer.parseInt(text, 16);
        }
        return null;
    }

    public static final OffsetDateTime parsePdmDateTime(String dateTimePart, String datePart, String timePart, ZoneId timeZone) {
        block4: {
            if (StringUtils.isNotBlank((CharSequence)dateTimePart)) {
                try {
                    return DateTimeUtils.toOffsetDateTime((LocalDateTime)LocalDateTime.parse(dateTimePart), (ZoneId)timeZone);
                }
                catch (DateTimeParseException e) {
                    if (!logger.isDebugEnabled()) break block4;
                    String msg = "The date time '" + dateTimePart + "' cannot be parsed. Using low precision time.";
                    logger.debug(msg, (Throwable)e);
                }
            }
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{datePart, timePart}) && !PATTERN_ONLY_ZEROES.matcher(datePart).matches()) {
            LocalDate date = LocalDate.parse(datePart, DateTimeFormats.PDM_DATE_FORMATTER);
            LocalTime time = LocalTime.parse(timePart, DateTimeFormats.PDM_TIME_FORMATTER);
            return DateTimeUtils.toOffsetDateTime((LocalDateTime)LocalDateTime.of(date, time), (ZoneId)timeZone);
        }
        return null;
    }

    public Short parseStatusNumber(String mnrString) {
        if (mnrString != null) {
            String mnrMsg = mnrString.substring(0, mnrString.length() - 2);
            String mnrOc = mnrString.substring(mnrString.length() - 2);
            if (!mnrOc.equals("00")) {
                logger.error("Non zero '{}' operation code from MNR '{}' is ignored.", (Object)mnrOc, (Object)mnrString);
            }
            return Short.parseShort(mnrMsg);
        }
        return null;
    }

    public static final BigDecimal toBigDecimal(Integer scaledValue, Integer scale) {
        if (scaledValue != null) {
            if (scale == null) {
                scale = 2;
            }
            return BigDecimal.valueOf(scaledValue.intValue(), scale);
        }
        return null;
    }

    public static final Duration durationFromMinutes(Integer minutes) {
        if (minutes == null) {
            return null;
        }
        return Duration.ofMinutes(minutes.intValue());
    }

    public static final String parseCardNumber(String zid) {
        if (StringUtils.isBlank((CharSequence)zid)) {
            return null;
        }
        if (StringUtils.containsOnly((CharSequence)(zid = zid.trim()), (String)"0")) {
            return null;
        }
        Matcher m = BANK_CARD_NUMBER.matcher(zid);
        if (m.matches()) {
            return m.group(1) + "#" + m.group(2);
        }
        m = BANK_CARD_ARTIFICIAL_NUMBER.matcher(zid);
        if (m.matches()) {
            if (StringUtils.containsOnly((CharSequence)m.group(1), (String)"0")) {
                return null;
            }
            return m.group(1) + "#";
        }
        m = CHIP_CARD_NUMBER.matcher(zid);
        if (m.matches()) {
            String number = m.group(1);
            if (number.equals("0")) {
                return null;
            }
            return number;
        }
        m = MIFARE_CARD_NUMBER.matcher(zid);
        if (m.matches()) {
            return zid.toLowerCase();
        }
        logger.warn("The card number typ for '{}' was not detected.", (Object)zid);
        return zid;
    }

    public Integer unifyParkingSpaceNumber(Integer psn) {
        if (psn == null || psn == 0) {
            return null;
        }
        return psn;
    }

    public static final int[] parseFwVersion(String ver) {
        int[] intVer = new int[]{-1, -1, -1, -1};
        if (ver == null) {
            return intVer;
        }
        int posLastSpace = (ver = ver.trim()).indexOf(32);
        if (posLastSpace > -1) {
            ver = ver.substring(0, posLastSpace);
        }
        String[] strVer = ver.split("\\.");
        int i = 0;
        for (String s : strVer) {
            try {
                intVer[i++] = Integer.parseInt(s.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return intVer;
    }

    public static final String parseAppVersion(String appVersionText) {
        int versionSuffixIndex = appVersionText.lastIndexOf(45);
        if (versionSuffixIndex > -1) {
            appVersionText = appVersionText.substring(0, versionSuffixIndex);
        }
        return appVersionText;
    }

    public String parseStatusReason(String statusReason) {
        if (StringUtils.isBlank((CharSequence)statusReason)) {
            return null;
        }
        try {
            JsonNode rootNode = this.pdmObjectMapper.readTree(statusReason);
            return rootNode.toString();
        }
        catch (JsonParseException e) {
            logger.info("Ignoring non-parsable extended status '{}'. {}.", (Object)statusReason, (Object)e.toString());
        }
        catch (IOException e) {
            logger.error("IO error while processing status reason", (Throwable)e);
        }
        return null;
    }

    public List<Map<String, Object>> parseRealTimeMultiRequest(String mrq) {
        if (StringUtils.isEmpty((CharSequence)mrq)) {
            return List.of();
        }
        try {
            return (List)this.pdmObjectMapper.readValue(mrq, RealTimeRequestRegisterService.REQUEST_LIST_TYPE_REFERENCE);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot parse real time multi request", e);
        }
    }

    public DeviceReport parseDeviceHourlyReport(String jsonReport) {
        if (jsonReport == null) {
            return null;
        }
        try {
            return (DeviceReport)this.pdmObjectMapper.readValue(jsonReport, DeviceReport.class);
        }
        catch (IOException e) {
            logger.error("Device report cannot be parsed.", (Throwable)e);
            return null;
        }
    }
}

