/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.runtime_monitor;

import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmRuntimeMonitor;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;

interface PdmRuntimeMonitorRepository
extends CrudRepository<PdmRuntimeMonitor, Integer> {
    @Query(value="UPDATE #{#entityName} SET online = null WHERE online = true")
    @Modifying(clearAutomatically=true, flushAutomatically=true)
    public void resetAliveStatusForOnline();

    @Query(value="UPDATE #{#entityName} SET lastKeepAlive = null")
    @Modifying(clearAutomatically=true, flushAutomatically=true)
    public void resetLastKeepAlive();

    @Query(value="UPDATE #{#entityName} SET online = ?1 WHERE pdm in (?2)")
    @Modifying(clearAutomatically=true, flushAutomatically=true)
    public void setOnlineForPdms(Boolean var1, Iterable<Pdm> var2);

    @Query(value="SELECT * FROM control.pdm_runtime WHERE   online = true   AND (GREATEST(kal_time, pay_time, sta_time, clr_time) + make_interval(mins => COALESCE(kal_inerval, ?1) * ?2)) < now ()", nativeQuery=true)
    public List<PdmRuntimeMonitor> findTransitingOfflineWithKeepAlive(int var1, int var2);

    @Query(value="SELECT * FROM control.pdm_runtime WHERE online = false AND (GREATEST(kal_time, pay_time, sta_time, clr_time) + make_interval(mins => COALESCE(kal_inerval, ?1))) > now ()", nativeQuery=true)
    public List<PdmRuntimeMonitor> findTransitingOnlineWithKeepAlive(int var1);

    @Query(value="UPDATE control.pdm_runtime SET online = true WHERE online is null AND (GREATEST(kal_time, pay_time, sta_time, clr_time) + make_interval(mins => COALESCE(kal_inerval, ?1))) > now ()", nativeQuery=true)
    @Modifying
    public int markWakingUp(int var1);

    public Optional<PdmRuntimeMonitor> findByPdm(Pdm var1);

    public List<PdmRuntimeMonitor> findByPdmIn(Iterable<Pdm> var1);
}

