/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.pdm.msg.json.conv;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.rtb.pcontrol.utils.DateTimeFormats;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactDateTimeDeserializer
extends StdDeserializer<LocalDateTime> {
    private static final Logger logger = LoggerFactory.getLogger(CompactDateTimeDeserializer.class);
    private static final long serialVersionUID = 3292113507255188954L;

    public CompactDateTimeDeserializer() {
        this(null);
    }

    public CompactDateTimeDeserializer(Class<?> clazz) {
        super(clazz);
    }

    public LocalDateTime deserialize(JsonParser jsonparser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String date = jsonparser.getText();
        try {
            LocalDateTime dateTime = LocalDateTime.parse(date, DateTimeFormats.COMPACT_SECONDS);
            return dateTime;
        }
        catch (DateTimeException e) {
            logger.error("Cannot parse report's date / time", (Throwable)e);
            return null;
        }
    }
}

