/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.parking_extension;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vdurmont.emoji.EmojiParser;
import de.rtb.pcon.core.parking_extension.ParkingExtensionService;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
class PermitExtensionRtrLpn
implements RealTimeRequest {
    @Autowired
    private ParkingExtensionService parkingExtensionService;
    @Autowired
    @Qualifier(value="pdmObjectMapper")
    private ObjectMapper pdmObjectMapper;

    PermitExtensionRtrLpn() {
    }

    public int getId() {
        return 3;
    }

    public String getDescription() {
        return "Parking permits for extension (LPN)";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        String lcn = ctx.getLicensePlate();
        Integer areaNr = ctx.global().getPdm().getZone().getArea().getId();
        Collection extendiblePermits = this.parkingExtensionService.findExtendablePermitsByLpn(lcn, areaNr.intValue());
        extendiblePermits.forEach(ep -> {
            ep.setPrice(ep.getPrice().scaleByPowerOfTen(ctx.getMonetaryScale()));
            ep.setPenaltyFee(ep.getPenaltyFee().scaleByPowerOfTen(ctx.getMonetaryScale()));
            ep.setSellingPdmName(EmojiParser.removeAllEmojis((String)ep.getSellingPdmName()));
        });
        return Map.of("TIC", extendiblePermits);
    }
}

