/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.msg_presistence;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.msg_presistence.ClearingTransactionService;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcon.model.CashBoxItem;
import de.rtb.pcon.model.CashKind;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.model.clearing.CardClearing;
import de.rtb.pcon.model.clearing.CashClearing;
import de.rtb.pcon.model.clearing.Clearing;
import de.rtb.pcon.model.clearing.OcifCardClearing;
import de.rtb.pcon.repositories.CashKindRepository;
import de.rtb.pcon.repositories.ClearingRepository;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ClearingTransactionService {
    private static final Logger log = LoggerFactory.getLogger(ClearingTransactionService.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private CashKindRepository cashKindRepo;
    @Autowired
    private ClearingRepository clearingRepo;
    @Autowired
    @Qualifier(value="pdmObjectMapper")
    private ObjectMapper pdmObjectMapper;
    private static final TypeReference<Map<String, Map<Integer, Integer>>> CCH_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;

    @Transactional
    public void persistCashBoxClearingMessage(PdmMessageDto msg) {
        if (msg.getBza() != null) {
            Clearing c2 = this.parsePdm7Clearing(msg);
            c2.setPdmTime(msg.getDatTim());
            c2.setServerTime(OffsetDateTime.now());
            c2.setPdm(msg.getPdm());
            c2.setCurrency(msg.getWkz());
            this.clearingRepo.save((Object)c2);
        } else {
            List clearings = this.parsePdm5Clearing(msg);
            clearings.forEach(c -> {
                c.setPdmTime(msg.getDatTim());
                c.setServerTime(OffsetDateTime.now());
                c.setPdm(msg.getPdm());
                c.setCurrency(msg.getWkz());
                this.clearingRepo.save(c);
            });
        }
    }

    private Clearing parsePdm7Clearing(PdmMessageDto msg) {
        return switch (2.$SwitchMap$de$rtb$pcon$model$PaymentType[msg.getBza().ordinal()]) {
            case 1 -> {
                CashClearing c;
                yield c = this.parseCoinClearing(msg);
            }
            case 2 -> {
                CashClearing c;
                yield c = this.parseBankNoteClearing(msg);
            }
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> {
                OcifCardClearing c = new OcifCardClearing();
                c.setPaymentType(msg.getBza());
                c.setValueSold(msg.getBte());
                c.setAccountName(msg.getAit() != null ? msg.getAit() : "");
                c.setTicketCount(msg.getAkt());
                c.setValueLifeLong(msg.getTok());
                this.setClearingNumbers((Clearing)c, msg);
                yield c;
            }
            case 14 -> {
                CardClearing c = new CardClearing();
                c.setPaymentType(PaymentType.GK);
                c.setValueSold(msg.getBtb());
                c.setTicketCount(msg.getAkt());
                c.setValueLifeLong(msg.getTok());
                this.setClearingNumbers((Clearing)c, msg);
                yield c;
            }
            case 15, 16 -> {
                CardClearing c = new CardClearing();
                c.setPaymentType(msg.getBza());
                c.setValueSold(msg.getBtd());
                c.setTicketCount(msg.getAkt());
                c.setValueLifeLong(msg.getTok());
                this.setClearingNumbers((Clearing)c, msg);
                yield c;
            }
            default -> {
                CardClearing c = new CardClearing();
                c.setPaymentType(msg.getBza());
                c.setValueSold(msg.getBta());
                c.setTicketCount(msg.getAkt());
                c.setValueLifeLong(msg.getTok());
                this.setClearingNumbers((Clearing)c, msg);
                yield c;
            }
        };
    }

    public List<Clearing> parsePdm5Clearing(PdmMessageDto msg) {
        CashClearing c;
        ArrayList<Clearing> clearings = new ArrayList<Clearing>();
        if (ClearingTransactionService.isNumberPositive((BigDecimal)msg.getKin())) {
            c = this.parseCoinClearing(msg);
            clearings.add((Clearing)c);
        }
        if (ClearingTransactionService.isNumberPositive((BigDecimal)msg.getBin())) {
            c = this.parseBankNoteClearing(msg);
            clearings.add((Clearing)c);
        }
        if (ClearingTransactionService.isNumberPositive((BigDecimal)msg.getBta())) {
            c = new CardClearing();
            c.setPaymentType(PaymentType.SLE);
            c.setValueSold(msg.getBta());
            this.setClearingNumbers((Clearing)c, msg);
            clearings.add((Clearing)c);
        }
        if (ClearingTransactionService.isNumberPositive((BigDecimal)msg.getBtb())) {
            c = new CardClearing();
            c.setPaymentType(PaymentType.GK);
            c.setValueSold(msg.getBtb());
            this.setClearingNumbers((Clearing)c, msg);
            clearings.add((Clearing)c);
        }
        if (ClearingTransactionService.isNumberPositive((BigDecimal)msg.getBtc())) {
            throw new IllegalStateException("Account BTC is not supported.");
        }
        if (ClearingTransactionService.isNumberPositive((BigDecimal)msg.getBtd())) {
            c = new CardClearing();
            c.setPaymentType(PaymentType.BANK_CARD);
            c.setValueSold(msg.getBtd());
            this.setClearingNumbers((Clearing)c, msg);
            clearings.add((Clearing)c);
        }
        if (ClearingTransactionService.isNumberPositive((BigDecimal)msg.getBte())) {
            c = new OcifCardClearing();
            c.setPaymentType(PaymentType.OCIF);
            c.setValueSold(msg.getBtd());
            c.setAccountName(msg.getAit() != null ? msg.getAit() : "");
            this.setClearingNumbers((Clearing)c, msg);
            clearings.add((Clearing)c);
        }
        if (ClearingTransactionService.isNumberPositive((BigDecimal)msg.getBtf())) {
            throw new IllegalStateException("Account BTF is not supported.");
        }
        if (ClearingTransactionService.isNumberPositive((BigDecimal)msg.getBtg())) {
            throw new IllegalStateException("Account BTG is not supported.");
        }
        if (ClearingTransactionService.isNumberPositive((BigDecimal)msg.getBth())) {
            throw new IllegalStateException("Account BTH is not supported.");
        }
        return clearings;
    }

    private void setClearingNumbers(Clearing c, PdmMessageDto msg) {
        c.setAsn(msg.getAsn());
        c.setClearingNumber(msg.getAbn());
        c.setTracer(msg.getTrc().intValue());
    }

    private CashClearing parseCoinClearing(PdmMessageDto msg) {
        CashClearing c = new CashClearing();
        c.setPaymentType(PaymentType.COINS);
        c.setValueSold(msg.getKin());
        c.setValueLifeLong(msg.getTob());
        c.setTicketCount(msg.getAbt());
        c.setValueRecharged(msg.getAuf());
        c.setCashBox(this.persistCahsBox(this.parseCoinBoxComposition(msg)));
        this.setClearingNumbers((Clearing)c, msg);
        return c;
    }

    private CashClearing parseBankNoteClearing(PdmMessageDto msg) {
        CashClearing c = new CashClearing();
        c.setPaymentType(PaymentType.BANK_NOTES);
        c.setValueSold(msg.getBin());
        c.setValueLifeLong(msg.getTon());
        c.setTicketCount(msg.getAnt());
        c.setValueRecharged(msg.getAub());
        c.setCashBox(this.persistCahsBox(this.parseCoinBoxComposition(msg)));
        this.setClearingNumbers((Clearing)c, msg);
        return c;
    }

    private List<CashBoxItem> persistCahsBox(Map<String, Map<BigDecimal, Integer>> cch) {
        if (MapUtils.isEmpty(cch)) {
            return List.of();
        }
        ArrayList<CashBoxItem> result = new ArrayList<CashBoxItem>();
        for (Map.Entry<String, Map<BigDecimal, Integer>> currencyAndCompositionEntry : cch.entrySet()) {
            String currency = currencyAndCompositionEntry.getKey();
            Map<BigDecimal, Integer> composition = currencyAndCompositionEntry.getValue();
            for (Map.Entry<BigDecimal, Integer> valueAndCountEntry : composition.entrySet()) {
                BigDecimal cashValue = valueAndCountEntry.getKey();
                Integer cashCount = valueAndCountEntry.getValue();
                CashKind cashKind = this.cashKindRepo.findByCurrencyAndValue(currency, cashValue).orElseGet(() -> this.mkPersistentCacheKind(cashValue, currency));
                CashBoxItem cb = new CashBoxItem();
                cb.setCashKind(cashKind);
                cb.setCount(cashCount.intValue());
                this.entityManager.persist((Object)cb);
                result.add(cb);
            }
        }
        return result;
    }

    private CashKind mkPersistentCacheKind(BigDecimal value, String currency) {
        log.debug("Creating new CashKind {} {}.", (Object)value, (Object)currency);
        return (CashKind)this.cashKindRepo.save((Object)CashKind.of((BigDecimal)value, (String)currency));
    }

    private static boolean isNumberPositive(BigDecimal n) {
        return n != null && n.doubleValue() > 0.0;
    }

    public Map<String, Map<BigDecimal, Integer>> parseCoinBoxComposition(PdmMessageDto m) {
        if (StringUtils.isBlank((CharSequence)m.getCch())) {
            return Map.of();
        }
        String cch = m.getCch();
        Integer numberOfDecimalPlaces = m.getDpa();
        TreeMap<String, Map<BigDecimal, Integer>> currencies = new TreeMap<String, Map<BigDecimal, Integer>>();
        try {
            Map jsonParserResult = (Map)this.pdmObjectMapper.readValue(cch, CCH_TYPE_REFERENCE);
            for (Map.Entry currencyMap : jsonParserResult.entrySet()) {
                TreeMap<BigDecimal, Integer> coinsPcontrol = new TreeMap<BigDecimal, Integer>();
                Map coinsPdm = (Map)currencyMap.getValue();
                for (Map.Entry coinInfo : coinsPdm.entrySet()) {
                    BigDecimal valuePcontrol = new BigDecimal((Integer)coinInfo.getKey()).scaleByPowerOfTen(-numberOfDecimalPlaces.intValue());
                    int count = (Integer)coinInfo.getValue();
                    coinsPcontrol.put(valuePcontrol, count);
                }
                currencies.put((String)currencyMap.getKey(), coinsPcontrol);
            }
        }
        catch (IOException e) {
            log.info("Old coin box composition format is not supported any more. Information about cash box composition is lost.");
        }
        return currencies;
    }
}

