/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.look_up.payment_filters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.look_up.payment_filters.CachePaymentFiltersDto;
import de.rtb.pcon.core.look_up.payment_filters.PaymentFilterLookupDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;

class CachePaymentFilterRowMapper
implements RowMapper<CachePaymentFiltersDto> {
    private static final Logger log = LoggerFactory.getLogger(CachePaymentFilterRowMapper.class);
    private ObjectMapper objectMapper;

    public CachePaymentFilterRowMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public CachePaymentFiltersDto mapRow(ResultSet rs, int rowNum) throws SQLException {
        Integer id = rs.getInt(1);
        String json = rs.getString(2);
        Long lastUsedId = rs.getLong(3);
        CachePaymentFiltersDto result = new CachePaymentFiltersDto();
        result.setId(id);
        result.setLastUsedId(lastUsedId);
        try {
            List cache = (List)this.objectMapper.readValue(json, (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, PaymentFilterLookupDto.class));
            result.setAreas(cache);
        }
        catch (JsonProcessingException e) {
            log.error("Canot parse cached value '" + json + "'", (Throwable)e);
        }
        return result;
    }
}

