/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import de.rtb.pcon.core.services.pdm_in.ServerResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.ip.tcp.serializer.SoftEndOfStreamException;
import org.springframework.integration.mapping.MessageMappingException;

class DataStreamSerializerTcp
implements Deserializer<byte[]>,
Serializer<ServerResponse> {
    private static final Logger log = LoggerFactory.getLogger(DataStreamSerializerTcp.class);
    protected int maxMessageSize = 2048;
    public static final DataStreamSerializerTcp INSTANCE = new DataStreamSerializerTcp();

    DataStreamSerializerTcp() {
    }

    protected void checkClosure(int bite) throws IOException {
        if (bite < 0) {
            log.debug("Socket closed during message assembly");
            throw new IOException("Socket closed during message assembly");
        }
    }

    public byte[] deserialize(InputStream inputStream) throws IOException {
        int bite = inputStream.read();
        if (bite < 0) {
            throw new SoftEndOfStreamException("Stream closed between payloads");
        }
        if (bite != 1) {
            throw new MessageMappingException("Expected SOH to begin message");
        }
        byte[] buffer = new byte[this.maxMessageSize];
        int n = 0;
        while ((bite = inputStream.read()) != 3) {
            this.checkClosure(bite);
            buffer[n++] = (byte)bite;
            if (n < this.maxMessageSize) continue;
            throw new IOException("ETX not found before max message length: " + this.maxMessageSize);
        }
        byte[] assembledData = new byte[n];
        System.arraycopy(buffer, 0, assembledData, 0, n);
        return assembledData;
    }

    public void serialize(ServerResponse response, OutputStream outputStream) throws IOException {
        if (response.contentType() == ServerResponse.ContentType.BINARY) {
            outputStream.write(response.toByteArray());
        } else {
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            o.write(1);
            o.write(response.toByteArray());
            o.write(3);
            outputStream.write(o.toByteArray());
        }
    }
}

