/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import de.rtb.pcon.core.integration.BlockingCallGuard;
import de.rtb.pcon.core.services.pdm_in.ScalableResourcesConfigurationService;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlockingCallGuardPlatformThreadsService
implements BlockingCallGuard {
    private static final Logger log = LoggerFactory.getLogger(BlockingCallGuardPlatformThreadsService.class);
    private AtomicInteger freeBlockingWebApiThreads;
    private int freeTcpUpdateThreads;

    BlockingCallGuardPlatformThreadsService(ScalableResourcesConfigurationService resCfg) {
        this.freeBlockingWebApiThreads = new AtomicInteger(resCfg.guardBlockingApiThreads);
        this.freeTcpUpdateThreads = Math.max(1, resCfg.guardFwUpdateThreads);
        int nrOfNormalThreads = resCfg.tpMainThreads - this.freeBlockingWebApiThreads.get() - this.freeTcpUpdateThreads;
        if (nrOfNormalThreads < 2) {
            throw new IllegalStateException("At least 2 threads has to be available for normal operations.");
        }
    }

    private boolean webCallStart() {
        int availableThreads = this.freeBlockingWebApiThreads.decrementAndGet();
        if (availableThreads >= 0) {
            log.trace("Obtained thread, {} remain.", (Object)availableThreads);
            return true;
        }
        this.freeBlockingWebApiThreads.incrementAndGet();
        log.warn("XXX Blocking WEB API call rejected because all threads are already taken.");
        return false;
    }

    private void webCallFinished() {
        int availableThreads = this.freeBlockingWebApiThreads.incrementAndGet();
        log.trace("Released thread, {} remain.", (Object)availableThreads);
    }

    public Map<String, Object> webCallExecute(Supplier<Map<String, Object>> sup) {
        if (this.webCallStart()) {
            try {
                Map<String, Object> map = sup.get();
                return map;
            }
            finally {
                this.webCallFinished();
            }
        }
        return Map.of("ERC", 6);
    }

    public int getNumberOfTcpDownloadThreads() {
        return this.freeTcpUpdateThreads;
    }
}

