/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.hw_components;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.hw_components.HardwareInfoParser;
import de.rtb.pcon.core.hw_components.HardwarePartsMonitorService;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmHwDevice;
import de.rtb.pcon.model.download.DownloadTarget;
import de.rtb.pcon.repositories.PdmHwDevicesRepository;
import de.rtb.pcontrol.utils.LoggerUtils;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HardwarePartsMonitorService {
    private static final Logger log = LoggerFactory.getLogger(HardwarePartsMonitorService.class);
    @Autowired
    private PdmHwDevicesRepository hwDeviceRepo;
    private final HardwareInfoParser hwInfoParser;
    private final ObjectMapper objectMapper;

    public HardwarePartsMonitorService(@Qualifier(value="pdmObjectMapper") ObjectMapper pdmObjectMapper, ObjectMapper stdObjectMapper) {
        this.hwInfoParser = new HardwareInfoParser(pdmObjectMapper, stdObjectMapper);
        this.objectMapper = stdObjectMapper;
    }

    Predicate<PdmHwDevice> isDeviceSame(PdmHwDevice pdmDev) {
        return d -> Objects.equals(pdmDev.getDeviceName(), d.getDeviceName()) && Objects.equals(pdmDev.getPart(), d.getPart());
    }

    Predicate<PdmHwDevice> isDeviceEquual(PdmHwDevice pdmDev) {
        return d -> {
            boolean eqDev = Objects.equals(pdmDev.getModel(), d.getModel());
            boolean eqSer = Objects.equals(pdmDev.getSerialNumber(), d.getSerialNumber());
            boolean eqVer = Objects.equals(pdmDev.getVersion(), d.getVersion());
            boolean eqUpd = pdmDev.isUpdatable() == d.isUpdatable();
            boolean eqJsn = Objects.equals(pdmDev.getProperties(), d.getProperties());
            if (!eqJsn && Objects.nonNull(pdmDev.getProperties()) && Objects.nonNull(d.getProperties())) {
                try {
                    eqJsn = Objects.equals(this.objectMapper.readTree(pdmDev.getProperties()), this.objectMapper.readTree(d.getProperties()));
                }
                catch (JsonProcessingException e) {
                    log.warn("Can not compare JSON of device properties '{}' <-> '{}'. {}", new Object[]{pdmDev.getProperties(), d.getProperties(), e.getMessage()});
                }
            }
            return eqDev && eqSer && eqVer && eqUpd && eqJsn;
        };
    }

    @Transactional
    public void processHardwareComponents(PdmMessageDto m) {
        Optional hwReport = Optional.empty();
        if (m.getMdl() != null) {
            log.debug("~ Hardware report");
            hwReport = this.hwInfoParser.paraseMdl(m.getMdl());
        } else if (m.getMnr() != null && StringUtils.startsWith((CharSequence)m.getVer(), (CharSequence)"5.")) {
            log.debug("~ Hardware change detection for PDM5");
            hwReport = this.hwInfoParser.parseV5(m);
        }
        hwReport.ifPresent(hr -> {
            switch (1.$SwitchMap$de$rtb$pcon$core$hw_components$DeviceReportMetaOperation[hr.meta().operation().ordinal()]) {
                case 1: {
                    this.saveHardwareInfoPut(m.getPdm(), m.getDatTim(), hr.devices());
                    break;
                }
                case 2: {
                    this.saveHardwareInfoAdd(m.getPdm(), m.getDatTim(), hr.devices(), Optional.empty());
                    break;
                }
                case 3: {
                    this.saveHardwareInfoDelete(m.getPdm(), hr.devices());
                }
            }
        });
    }

    void saveHardwareInfoPut(Pdm pdm, OffsetDateTime pdmTime, List<PdmHwDevice> pdmDevices) {
        List dbDevices = this.hwDeviceRepo.findByPdm(pdm);
        this.saveHardwareInfoAdd(pdm, pdmTime, pdmDevices, Optional.of(dbDevices));
        for (PdmHwDevice dbDev : dbDevices) {
            if (DownloadTarget.MODEM.equals((Object)dbDev.getTarget()) || !pdmDevices.stream().filter(this.isDeviceSame(dbDev)).findAny().isEmpty()) continue;
            this.removeDevice(dbDev, pdm);
        }
    }

    private void saveHardwareInfoAdd(Pdm pdm, OffsetDateTime pdmTime, List<PdmHwDevice> pdmDevices, Optional<List<PdmHwDevice>> dbDevicesPreloaded) {
        List dbDevices = dbDevicesPreloaded.orElseGet(() -> this.hwDeviceRepo.findByPdm(pdm));
        for (PdmHwDevice pdmDev : pdmDevices) {
            dbDevices.stream().filter(this.isDeviceSame(pdmDev)).findAny().ifPresentOrElse(dbDev -> this.updateDevice(pdmDev, dbDev, pdmTime, pdm), () -> this.addDevice(pdmDev, pdmTime, pdm));
        }
    }

    private void saveHardwareInfoDelete(Pdm pdm, List<PdmHwDevice> pdmDevices) {
        List dbDevices = this.hwDeviceRepo.findByPdm(pdm);
        for (PdmHwDevice pdmDevice : pdmDevices) {
            dbDevices.stream().filter(this.isDeviceSame(pdmDevice)).forEach(d -> this.removeDevice(d, pdm));
        }
    }

    void addDevice(PdmHwDevice pdmDev, OffsetDateTime pdmTime, Pdm pdm) {
        if (log.isTraceEnabled()) {
            log.trace("Device '{}' attached to {}: {}", new Object[]{pdmDev.toPathString(), LoggerUtils.log((Pdm)pdm), pdmDev});
        }
        pdmDev.setPdm(pdm);
        pdmDev.setTimestamp(pdmTime);
        this.hwDeviceRepo.save((Object)pdmDev);
    }

    void updateDevice(PdmHwDevice pdmDevice, PdmHwDevice dbDevice, OffsetDateTime pdmTime, Pdm pdm) {
        if (!this.isDeviceEquual(pdmDevice).test(dbDevice)) {
            if (log.isTraceEnabled()) {
                log.trace("Device '{}' updated on {}: {}", new Object[]{pdmDevice.toPathString(), LoggerUtils.log((Pdm)pdm), pdmDevice});
            }
            dbDevice.copyValuesFrom(pdmDevice);
            dbDevice.setTimestamp(pdmTime);
        }
    }

    void removeDevice(PdmHwDevice dbDevice, Pdm pdm) {
        if (log.isTraceEnabled()) {
            log.trace("Device '{}' detached from {}: {}", new Object[]{dbDevice.toPathString(), LoggerUtils.log((Pdm)pdm), dbDevice});
        }
        this.hwDeviceRepo.delete((Object)dbDevice);
    }

    public Map<Pdm, List<PdmHwDevice>> fetchUpgradableComponents(Area area) {
        return this.hwDeviceRepo.findUpdatableDevicesInArea(area).stream().filter(d -> d.isUpdatable() && d.getTarget().deviceType() != null).collect(Collectors.groupingBy(PdmHwDevice::getPdm));
    }
}

