/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.fw_download;

import de.rtb.pcon.model.download.DownloadTarget;
import java.util.Set;

public class FirmwareDownloadServiceHelper {
    public static final Set<Short> DOWNLOAD_MESSAGE_NUMBERS = Set.of((short)91, (short)112, (short)113, (short)114, (short)124, (short)158, (short)159, (short)225, (short)256, (short)226, (short)258);

    private FirmwareDownloadServiceHelper() {
    }

    public static DownloadTarget extractDownloadTarget(int mnr, Integer uty) {
        if (uty != null) {
            return DownloadTarget.fromUty((int)uty);
        }
        return switch (mnr) {
            case 91 -> DownloadTarget.CONFIG;
            case 112 -> DownloadTarget.MODEM;
            case 113 -> DownloadTarget.PDM;
            case 114 -> DownloadTarget.PDM;
            case 124 -> DownloadTarget.CARD_READER_1;
            case 158 -> DownloadTarget.PRINTER_1;
            case 159 -> DownloadTarget.MODEM;
            default -> throw new IllegalStateException("The message number " + mnr + " is not recognized as download state change.");
        };
    }
}

