/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.cash_box;

import de.rtb.pcon.core.cash_box.CashBoxLevelRepository;
import de.rtb.pcon.core.cash_box.CashBoxMonitorPaymentRepository;
import de.rtb.pcon.model.CashBoxLevel;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.model.Pdm;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CashBoxMonitorService {
    public static final Set<PaymentType> REGISTERED_PAYMENTS = Set.of(PaymentType.COINS, PaymentType.BANK_NOTES);
    private static final Logger log = LoggerFactory.getLogger(CashBoxMonitorService.class);
    @Autowired
    private CashBoxLevelRepository cbRepo;
    @Autowired
    private CashBoxMonitorPaymentRepository cbPayment;

    @Transactional
    public void addPayment(Pdm pdm, PaymentType paymentType, PaymentReason paymentReason, String currency, BigDecimal value) {
        if (PaymentReason.RECONCILIATION.equals((Object)paymentReason)) {
            log.trace("Payment of type {} is ignored for cash box level.", (Object)paymentReason);
            return;
        }
        if (!REGISTERED_PAYMENTS.contains(paymentType)) {
            return;
        }
        int nrOfUpdatedRecoreds = this.cbRepo.addToCashBox(pdm, paymentType, currency, value);
        switch (nrOfUpdatedRecoreds) {
            case 0: {
                CashBoxLevel cb = this.createCashBoxLevelEntry(pdm, paymentType, currency);
                cb.setLevel(value);
                log.trace("Created new cash box level entry record. Payment {}, {} {}", new Object[]{paymentType, value, currency});
                break;
            }
            case 1: {
                log.trace("Cash box registered payment {}, {} {}", new Object[]{paymentType, value, currency});
                break;
            }
            default: {
                log.error("There is {} records for {}, {}. Only one should exist.", new Object[]{nrOfUpdatedRecoreds, paymentType, currency});
            }
        }
    }

    @Transactional
    public void resetPayments(Pdm pdm, PaymentType paymentType, String currency, OffsetDateTime clearingTime) {
        if (!REGISTERED_PAYMENTS.contains(paymentType)) {
            return;
        }
        BigDecimal moneyAlreadyIn = this.cbPayment.findIncomeFromClearing(pdm, paymentType, currency, clearingTime).orElse(BigDecimal.ZERO);
        log.debug("Found {} {} in cash box after received clearing for {}.", new Object[]{moneyAlreadyIn, currency, paymentType});
        CashBoxLevel cashBox = this.cbRepo.findByPdmAndPaymentTypeAndCurrency(pdm, paymentType, currency).orElseGet(() -> this.createCashBoxLevelEntry(pdm, paymentType, currency));
        cashBox.setLevel(moneyAlreadyIn);
        cashBox.setLastClearing(clearingTime);
        log.trace("Cash box {} was reset to {} {}.", new Object[]{paymentType, moneyAlreadyIn, currency});
    }

    @Transactional(readOnly=true)
    public List<CashBoxLevel> findForPdms(Collection<Pdm> pdms) {
        return this.cbRepo.findByLevelNotNullAndPdmIn(pdms);
    }

    private CashBoxLevel createCashBoxLevelEntry(Pdm pdm, PaymentType paymentType, String currency) {
        CashBoxLevel c = new CashBoxLevel();
        c.setPdm(pdm);
        c.setPaymentType(paymentType);
        c.setCurrency(currency);
        c.setLevel(BigDecimal.ZERO);
        return (CashBoxLevel)this.cbRepo.save((Object)c);
    }
}

