/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.config.mvc;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperFactoryBean;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class MessageConverterConfig
implements WebMvcConfigurer {
    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        List newConverters = converters.stream().filter(c -> !(c instanceof MappingJackson2HttpMessageConverter) && !(c instanceof MappingJackson2XmlHttpMessageConverter)).collect(Collectors.toList());
        MappingJackson2HttpMessageConverter jsonConverter = new MappingJackson2HttpMessageConverter();
        jsonConverter.setObjectMapper(this.jacksonObjectMapper().getObject());
        newConverters.add(jsonConverter);
        MappingJackson2XmlHttpMessageConverter xmlConverter = new MappingJackson2XmlHttpMessageConverter();
        xmlConverter.setObjectMapper(this.jacksonXmlMapper().getObject());
        newConverters.add(xmlConverter);
        converters.clear();
        converters.addAll(newConverters);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.defaultContentType(new MediaType[]{MediaType.APPLICATION_JSON});
    }

    @Bean
    @Primary
    Jackson2ObjectMapperFactoryBean jacksonObjectMapper() {
        Jackson2ObjectMapperFactoryBean omf = new Jackson2ObjectMapperFactoryBean();
        omf.setFeaturesToDisable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS});
        return omf;
    }

    @Bean(name={"pdmObjectMapper"})
    ObjectMapper pdmObjectMapper() {
        JsonFactory jsonFactory = JsonFactory.builder().enable(JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES).disable(JsonWriteFeature.QUOTE_FIELD_NAMES).enable(StreamWriteFeature.WRITE_BIGDECIMAL_AS_PLAIN).build();
        ObjectMapper pdmObjectMapper = new ObjectMapper(jsonFactory);
        pdmObjectMapper.registerModule((Module)new JavaTimeModule());
        pdmObjectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        pdmObjectMapper.registerModule((Module)new Jdk8Module());
        pdmObjectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        pdmObjectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return pdmObjectMapper;
    }

    @Bean
    Jackson2ObjectMapperFactoryBean jacksonXmlMapper() {
        Jackson2ObjectMapperFactoryBean omf = new Jackson2ObjectMapperFactoryBean();
        omf.setFeaturesToDisable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS});
        omf.setCreateXmlMapper(true);
        return omf;
    }
}

