/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.config;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SwaggerConfig {
    public static final String DISCLAIMER = "<h3 style='margin-top: 0;'>Disclaimer</h3>\n\n<p><strong>This is not official RTB documentation.</strong>\nContent is automatically generated from for source code by <a href='https://springdoc.org/'>SpringDoc library</a> without any warranty.\nAlways contact <a href='mailto:parking-helpdesk@rtb-bl.de'>parking help desk</a> for official documentation.\n</p>";

    @Bean
    GroupedOpenApi enforcementRtbV1Group() {
        String apiDescription = "<h2>Enforcement API</h2>\n<h3>Description</h3>\n<p>Allows checking of parking permits validity. Role <code>ROLE_ENFORCEMENT_VIEW</code> is required.</p>\n<h3>Typical use case</h3>\n<ol>\n  <li>Read zones available for enforcement by calling <code>.../zones/tree</code> </li>\n  <li>Verify permit by calling<code>.../zones/{id}/permit/{permit}</code> where {id} is id of zone were permit has to be checked and {permit} is either LPN or PSN.</li>\n</ol>";
        return GroupedOpenApi.builder().group("Enforcement").pathsToMatch(new String[]{"/api/enforcement/v1/**"}).addOpenApiCustomizer(openApi -> openApi.getInfo().setDescription("<h3 style='margin-top: 0;'>Disclaimer</h3>\n\n<p><strong>This is not official RTB documentation.</strong>\nContent is automatically generated from for source code by <a href='https://springdoc.org/'>SpringDoc library</a> without any warranty.\nAlways contact <a href='mailto:parking-helpdesk@rtb-bl.de'>parking help desk</a> for official documentation.\n</p><h2>Enforcement API</h2>\n<h3>Description</h3>\n<p>Allows checking of parking permits validity. Role <code>ROLE_ENFORCEMENT_VIEW</code> is required.</p>\n<h3>Typical use case</h3>\n<ol>\n  <li>Read zones available for enforcement by calling <code>.../zones/tree</code> </li>\n  <li>Verify permit by calling<code>.../zones/{id}/permit/{permit}</code> where {id} is id of zone were permit has to be checked and {permit} is either LPN or PSN.</li>\n</ol>")).build();
    }

    @Bean
    GroupedOpenApi enforcementAimsGroup() {
        String apiDescription = "<h2>Integration with AIMS company</h2>\n<h3>Important</h3>\n<p>There area two variants or API <code>aims</code> and <code>aims2</code>.</p>\n\n<p>Deprecated variant with API key.<p>\n<p>\nAIMS: <strong>This implementation is considered un-save</strong>.\nIt stores API key in database as plain text and goes around spring security framework.\nPlease migrate to AIMS2. This variant will be removed soon.\n</p>\n\n<h3>Description</h3>\n\n<p>\nThe interface is designed to connect 3rd party enforcement electronic devices to check the legitimacy of parking car.\nThe data will be accessible via REST API provided by PControl server.\n<p>\n\n<h4>Authentication</h4>\n<p>\n<strong>AIMS1</strong>: The all mentioned methods requires authentication to prevent unauthorized access.\nA caller must include parameters client and password to provide credentials.\nThe client is the area code and the password is the API key, which is set in the properties of the area.\nThose parameters have to be supplied with every method despite of they are not explicitly mentioned.\nOtherwise return code 401 (Unauthorized) is returned.\n</p>\n\n<p>\n<strong>This implementation is considered un-save</strong>.\nIt stores API key in database as plain text and goes around spring security framework.\nPlease migrate to AIMS2.\n</p>\n\n<p>\n<strong>AIMS2</strong>: Basic authentication is used.\nCaller has to have role <code>ROLE_ENFORCEMENT_VIEW</code> to be able to view data.\n</p>\n\n<p>\n<strong>Important</strong>: Data are not encrypted by default.\nDespite of the interface works via both HTTP and HTTPS it is strictly recommended to use the interface only together with HTTPS protocol.\n</p>";
        return GroupedOpenApi.builder().group("AIMS enforcement").pathsToMatch(new String[]{"/api/enforcement/aims2/**"}).addOpenApiCustomizer(openApi -> openApi.getInfo().setDescription("<h3 style='margin-top: 0;'>Disclaimer</h3>\n\n<p><strong>This is not official RTB documentation.</strong>\nContent is automatically generated from for source code by <a href='https://springdoc.org/'>SpringDoc library</a> without any warranty.\nAlways contact <a href='mailto:parking-helpdesk@rtb-bl.de'>parking help desk</a> for official documentation.\n</p><h2>Integration with AIMS company</h2>\n<h3>Important</h3>\n<p>There area two variants or API <code>aims</code> and <code>aims2</code>.</p>\n\n<p>Deprecated variant with API key.<p>\n<p>\nAIMS: <strong>This implementation is considered un-save</strong>.\nIt stores API key in database as plain text and goes around spring security framework.\nPlease migrate to AIMS2. This variant will be removed soon.\n</p>\n\n<h3>Description</h3>\n\n<p>\nThe interface is designed to connect 3rd party enforcement electronic devices to check the legitimacy of parking car.\nThe data will be accessible via REST API provided by PControl server.\n<p>\n\n<h4>Authentication</h4>\n<p>\n<strong>AIMS1</strong>: The all mentioned methods requires authentication to prevent unauthorized access.\nA caller must include parameters client and password to provide credentials.\nThe client is the area code and the password is the API key, which is set in the properties of the area.\nThose parameters have to be supplied with every method despite of they are not explicitly mentioned.\nOtherwise return code 401 (Unauthorized) is returned.\n</p>\n\n<p>\n<strong>This implementation is considered un-save</strong>.\nIt stores API key in database as plain text and goes around spring security framework.\nPlease migrate to AIMS2.\n</p>\n\n<p>\n<strong>AIMS2</strong>: Basic authentication is used.\nCaller has to have role <code>ROLE_ENFORCEMENT_VIEW</code> to be able to view data.\n</p>\n\n<p>\n<strong>Important</strong>: Data are not encrypted by default.\nDespite of the interface works via both HTTP and HTTPS it is strictly recommended to use the interface only together with HTTPS protocol.\n</p>")).build();
    }

    @Bean
    GroupedOpenApi dataExportGroup() {
        String apiDescription = "<h2>Data export API</h2>\n<h3>Description</h3>\n<p>\n<em>Exports data from database outside of PDM.control. </em>\nAPI is intended to be used by 3rd party systems which needs <em>raw</em> data from PDMs for additional processing.\n</p>\n\n<h4>Security</h4>\n<p>\nIn order to access API user needs to have valid account in PDM.control and <code>ROLE_PCON_VIEW</code>.\nAdditionally it is necessary have <code>ROLE_ECONOMIST</code> if you want monetary values should be visible.\nTogether with request it is necessary to provide credentials using <a href=\"https:en.wikipedia.org/wiki/Basic_access_authentication\">Basic Authorization</a> method.\n</p>\n<p>\nStatus messages which can be read depend on which Areas can the authenticated user access.\nIf administrator changes Area assignment for current user the result of methods may change.\n</p>\n\n<h4>Time format</h4>\n<p>\nData and time is internally stored with UTC time zone.\nHowever to the API are all time stamps recalculated to caller's time zone.\nTime zone can be set in account properties in PDM control.\nTime stamps are formatted in <a href=\"https:en.wikipedia.org/wiki/ISO_860\">ISO-8601</a> format e.g. 2020-05-28T17:11:12.\n</p>\n\n<h4>Content negotiation</h4>\n<p>\nAPI can provide data in two formats JSON and XML.\nBy default are the data send in JSON format.\nOutput format can be selected by setting <code>Accept</code> header.\nAllowed values are <code>application/json</code> for JSON format and <code>application/xml</code> for XML format.\nIf nothing is specified JSON is used.\nUnfortunately the tool does not build XML responses correctly therefore they are not included.\nHowever the general structure and field names are same as in case of JSON.\nFeel free to experiment with REST client.\n</p>\n\n<h4>Slicing</h4>\n<p>\nEvery method returns at most <code>${pcon.api.export.maxPageSize}</code> (configuration parameter) records within one request.\nTo changed it adjust property of PDM.control if different value is needed.\nBe careful to provide to high value.\nData from database need to be loaded to memory in order to convert them to appropriate format (JSON / XML).\nHigher page size requires more memory.\n</p>\n<p>\nIt is possible to use request parameter parameter <code>pageSize</code> to decrease number of returned elements.\nNevertheless provided page size will never excite configured value (<code>${pcon.api.export.maxPageSize}</code>).\nIf provided number is higher then default value then default value is used.\nDefault page size is 10 000 at the time of writing this documentation.\nRepeat request multiple times to read all data.\n</p>\n\n<h3>Typical use case</h3>\n<p>\nBe aware that it importing historical data from deep past can be slow and usually not needed.\nOur system returns recent data quickly, but it may take some time to find old data.\n</p>\n\n<p>\n<ol>\n  <li>\n    Optionally read project structure by calling <code>.../project</code>.\n  </li>\n  <li>\n    Find continuation token for the date from which you want to import.\n    Call <code>.../&lt;payments|status&gt;/findToken?date=2021-04-20T11%3A53</code> to get value of continuation token.\n  </li>\n  <li>\n    Read data by calling <code>.../&lt;payments|status&gt;byOrder?continuationToken=4738563</code> with value of continuation token returned in step 2.\n    As long as response indicates more entries by field <code>hasMore</code> with value <code>true</code>continue reading.\n    Number of entries in the response can be controlled by query parameter <code>pageSize</code>.\n  </li>\n</ol>\n</p>";
        return GroupedOpenApi.builder().group("Export").pathsToMatch(new String[]{"/api/export/v1/**"}).addOpenApiCustomizer(openApi -> openApi.getInfo().setDescription("<h3 style='margin-top: 0;'>Disclaimer</h3>\n\n<p><strong>This is not official RTB documentation.</strong>\nContent is automatically generated from for source code by <a href='https://springdoc.org/'>SpringDoc library</a> without any warranty.\nAlways contact <a href='mailto:parking-helpdesk@rtb-bl.de'>parking help desk</a> for official documentation.\n</p><h2>Data export API</h2>\n<h3>Description</h3>\n<p>\n<em>Exports data from database outside of PDM.control. </em>\nAPI is intended to be used by 3rd party systems which needs <em>raw</em> data from PDMs for additional processing.\n</p>\n\n<h4>Security</h4>\n<p>\nIn order to access API user needs to have valid account in PDM.control and <code>ROLE_PCON_VIEW</code>.\nAdditionally it is necessary have <code>ROLE_ECONOMIST</code> if you want monetary values should be visible.\nTogether with request it is necessary to provide credentials using <a href=\"https:en.wikipedia.org/wiki/Basic_access_authentication\">Basic Authorization</a> method.\n</p>\n<p>\nStatus messages which can be read depend on which Areas can the authenticated user access.\nIf administrator changes Area assignment for current user the result of methods may change.\n</p>\n\n<h4>Time format</h4>\n<p>\nData and time is internally stored with UTC time zone.\nHowever to the API are all time stamps recalculated to caller's time zone.\nTime zone can be set in account properties in PDM control.\nTime stamps are formatted in <a href=\"https:en.wikipedia.org/wiki/ISO_860\">ISO-8601</a> format e.g. 2020-05-28T17:11:12.\n</p>\n\n<h4>Content negotiation</h4>\n<p>\nAPI can provide data in two formats JSON and XML.\nBy default are the data send in JSON format.\nOutput format can be selected by setting <code>Accept</code> header.\nAllowed values are <code>application/json</code> for JSON format and <code>application/xml</code> for XML format.\nIf nothing is specified JSON is used.\nUnfortunately the tool does not build XML responses correctly therefore they are not included.\nHowever the general structure and field names are same as in case of JSON.\nFeel free to experiment with REST client.\n</p>\n\n<h4>Slicing</h4>\n<p>\nEvery method returns at most <code>${pcon.api.export.maxPageSize}</code> (configuration parameter) records within one request.\nTo changed it adjust property of PDM.control if different value is needed.\nBe careful to provide to high value.\nData from database need to be loaded to memory in order to convert them to appropriate format (JSON / XML).\nHigher page size requires more memory.\n</p>\n<p>\nIt is possible to use request parameter parameter <code>pageSize</code> to decrease number of returned elements.\nNevertheless provided page size will never excite configured value (<code>${pcon.api.export.maxPageSize}</code>).\nIf provided number is higher then default value then default value is used.\nDefault page size is 10 000 at the time of writing this documentation.\nRepeat request multiple times to read all data.\n</p>\n\n<h3>Typical use case</h3>\n<p>\nBe aware that it importing historical data from deep past can be slow and usually not needed.\nOur system returns recent data quickly, but it may take some time to find old data.\n</p>\n\n<p>\n<ol>\n  <li>\n    Optionally read project structure by calling <code>.../project</code>.\n  </li>\n  <li>\n    Find continuation token for the date from which you want to import.\n    Call <code>.../&lt;payments|status&gt;/findToken?date=2021-04-20T11%3A53</code> to get value of continuation token.\n  </li>\n  <li>\n    Read data by calling <code>.../&lt;payments|status&gt;byOrder?continuationToken=4738563</code> with value of continuation token returned in step 2.\n    As long as response indicates more entries by field <code>hasMore</code> with value <code>true</code>continue reading.\n    Number of entries in the response can be controlled by query parameter <code>pageSize</code>.\n  </li>\n</ol>\n</p>")).build();
    }

    @Bean
    OpenAPI apiInfo() {
        return new OpenAPI().info(new Info().title("PDM.control").description("Central software for Park and Display Machines (PDM).").contact(new Contact().name("RTB GmbH & Co.KG").url("http://www.rtb-bl.de/").email("parking-helpdesk@rtb-bl.de")).license(new License().name("Unknown license").url("https://www.rtb-bl.de/")));
    }
}

