/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.enforcement.aims;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import de.rtb.pcon.api.enforcement.aims.service.EnfZone;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="The Zone representation for AIMs")
@JacksonXmlRootElement(localName="scope")
public class AimsScope {
    @Schema(description="The scope id.", example="2")
    @JacksonXmlProperty(isAttribute=true)
    private int id;
    @Schema(description="The scope name.", example="My zone")
    @JacksonXmlText
    private String name;
    @Schema(description="The scope type. It can be only 'zone'.", example="zone")
    @JacksonXmlProperty(isAttribute=true)
    private String type;

    public AimsScope() {
        this.type = "zone";
    }

    public AimsScope(int id, String name) {
        this.id = id;
        this.name = name;
        this.type = "zone";
    }

    public AimsScope(EnfZone ez) {
        this.id = ez.getId();
        this.name = ez.getName();
        this.type = "zone";
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AimsScope other = (AimsScope)obj;
        return this.id == other.id;
    }
}

