/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.payments;

import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.ui.controllers.reports.payments.CategoryStrategy;
import de.rtb.pcon.ui.controllers.reports.payments.CurrencyCategoryStrategy;
import de.rtb.pcon.ui.controllers.reports.payments.DurationCategoryStrategy;
import de.rtb.pcon.ui.controllers.reports.payments.PaymentReportRepository;
import de.rtb.pcon.ui.controllers.reports.payments.SaleReport;
import de.rtb.pcon.ui.controllers.reports.payments.SaleReportByPdm;
import de.rtb.pcon.ui.controllers.reports.payments.SaleReportRowCategory;
import de.rtb.pcon.ui.controllers.reports.payments.SaleReportRowCategoryQuaterDow;
import de.rtb.pcon.ui.controllers.reports.payments.SaleReportRowCategoryYearMonth;
import de.rtb.pcon.ui.controllers.reports.payments.SaleReportRowCategoryYearQuater;
import de.rtb.pcon.ui.controllers.reports.payments.SaleReportRowCategoryYearWeek;
import de.rtb.pcon.ui.controllers.reports.payments.TimeCategoryStrategy;
import de.rtb.pcon.ui.controllers.reports.payments.TransactionCollectror;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcontrol.utils.DateTimeUtils;
import de.rtb.pcontrol.utils.OccurenceCounter;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
class PaymentReportService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private I18nService i18nService;
    @Autowired
    private PaymentReportRepository paymentReportRepository;
    private static final DateTimeFormatter postgresDateTimeForamtter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    PaymentReportService() {
    }

    @Transactional(readOnly=true)
    public Map<String, TransactionCollectror<LocalTime, BigDecimal>> calculateAmount(OffsetDateTime from, OffsetDateTime to, Collection<Pdm> pdms, Collection<PaymentType> paymentTypes, Collection<PaymentReason> paymentReasons, Duration timeStep, BigDecimal valueStep) {
        if (pdms.isEmpty() || paymentTypes.isEmpty() || paymentReasons.isEmpty()) {
            return Collections.emptyMap();
        }
        TimeCategoryStrategy rowCategoryStrategy = new TimeCategoryStrategy(timeStep);
        CurrencyCategoryStrategy colCategoryStrategy = new CurrencyCategoryStrategy(valueStep);
        HashMap<String, TransactionCollectror<LocalTime, BigDecimal>> collectors = new HashMap<String, TransactionCollectror<LocalTime, BigDecimal>>();
        OccurenceCounter transactionCounter = new OccurenceCounter();
        try (Stream tansactionData = this.paymentReportRepository.streamPaymentsForAmountReport(pdms, from, to, paymentReasons, paymentTypes);){
            ZoneId userTimeZone = this.i18nService.userTimeZoneId();
            tansactionData.forEach(arg_0 -> this.lambda$calculateAmount$1(userTimeZone, collectors, (CategoryStrategy)rowCategoryStrategy, (CategoryStrategy)colCategoryStrategy, transactionCounter, arg_0));
            LinkedHashMap<String, TransactionCollectror> sortedCollectors = new LinkedHashMap<String, TransactionCollectror>();
            Map transactionHistogram = transactionCounter.asMapByCount();
            for (String currency : transactionHistogram.keySet()) {
                sortedCollectors.put(currency, (TransactionCollectror)collectors.get(currency));
            }
        }
        return collectors;
    }

    @Transactional(readOnly=true)
    public TransactionCollectror<LocalTime, Duration> calculateDuration(OffsetDateTime from, OffsetDateTime to, Collection<Pdm> pdms, Collection<PaymentType> paymentTypes, Collection<PaymentReason> paymentReasons, Duration timeStep, Duration valueStep) {
        TimeCategoryStrategy rowCategoryStrategy = new TimeCategoryStrategy(timeStep);
        DurationCategoryStrategy colCategoryStrategy = new DurationCategoryStrategy(valueStep);
        if (pdms.isEmpty() || paymentTypes.isEmpty() || paymentReasons.isEmpty()) {
            return new TransactionCollectror((CategoryStrategy)rowCategoryStrategy, (CategoryStrategy)colCategoryStrategy);
        }
        TransactionCollectror collector = new TransactionCollectror((CategoryStrategy)rowCategoryStrategy, (CategoryStrategy)colCategoryStrategy);
        ZoneId userTimeZoneId = this.i18nService.userTimeZoneId();
        try (Stream paymentDataStream = this.paymentReportRepository.streamPaymentsForDurationReport(pdms, from, to, paymentReasons, paymentTypes);){
            paymentDataStream.forEach(pt -> {
                this.entityManager.detach(pt);
                Duration parkDuration = Duration.between(pt.getId().getPdmTime(), pt.getParkEndTime());
                LocalTime locParkStart = DateTimeUtils.toLocalDateTime((OffsetDateTime)pt.getId().getPdmTime(), (ZoneId)userTimeZoneId).toLocalTime();
                collector.addData((Object)locParkStart, (Object)parkDuration);
            });
        }
        return collector;
    }

    @Transactional(readOnly=true)
    public SaleReport calculateSales(LocalDateTime from, LocalDateTime to, Collection<Pdm> pdms, Class<? extends SaleReportRowCategory> timeGroupingClass) {
        if (pdms.isEmpty()) {
            return new SaleReport(timeGroupingClass);
        }
        Set pdmIds = pdms.stream().map(Pdm::getId).collect(Collectors.toSet());
        ZoneId userTimeZoneId = this.i18nService.userTimeZoneId();
        this.entityManager.createNativeQuery("SET LOCAL TIME ZONE '" + userTimeZoneId.toString() + "'").executeUpdate();
        StringBuilder qsbGroups = new StringBuilder();
        if (SaleReportRowCategoryYearWeek.class.equals(timeGroupingClass)) {
            qsbGroups.append("(CAST (EXTRACT(ISOYEAR FROM pay_ts) AS INTEGER)) AS res_group_major, ");
            qsbGroups.append("(CAST (EXTRACT(WEEK FROM pay_ts) AS INTEGER)) AS res_group_minor, ");
        } else if (SaleReportRowCategoryYearMonth.class.equals(timeGroupingClass)) {
            qsbGroups.append("(CAST (EXTRACT(YEAR FROM pay_ts) AS INTEGER)) AS res_group_major, ");
            qsbGroups.append("(CAST (EXTRACT(MONTH FROM pay_ts) AS INTEGER)) AS res_group_minor, ");
        } else if (SaleReportRowCategoryYearQuater.class.equals(timeGroupingClass)) {
            qsbGroups.append("(CAST (EXTRACT(YEAR FROM pay_ts) AS INTEGER)) AS res_group_major, ");
            qsbGroups.append("(CAST (EXTRACT(QUARTER FROM pay_ts) AS INTEGER)) AS res_group_minor, ");
        } else if (SaleReportRowCategoryQuaterDow.class.equals(timeGroupingClass)) {
            qsbGroups.append("(CAST (EXTRACT(QUARTER FROM pay_ts) AS INTEGER)) AS res_group_major, ");
            qsbGroups.append("(CAST (EXTRACT(ISODOW FROM pay_ts) AS INTEGER)) AS res_group_minor, ");
        } else {
            throw new IllegalStateException("Unsupported time category " + timeGroupingClass.getName());
        }
        List dbResultSaleCounts = this.entityManager.createNativeQuery("SELECT " + qsbGroups.toString() + "(CAST (EXTRACT(HOUR FROM pay_ts) AS INTEGER)) res_hour_of_day, (CAST (COUNT (*) AS INTEGER)) as res_payment_count FROM control.payment WHERE pdm_id IN (:pdmIds) AND pay_ts >= '" + from.format(postgresDateTimeForamtter) + "' AND pay_ts < '" + to.format(postgresDateTimeForamtter) + "' AND pay_reason = '" + PaymentReason.PURCHASE.name() + "' GROUP BY res_group_major, res_group_minor, res_hour_of_day ORDER BY res_group_major, res_group_minor, res_hour_of_day").setParameter("pdmIds", pdmIds).getResultList();
        TreeBasedTable saleCounts = TreeBasedTable.create();
        for (Object[] objects : dbResultSaleCounts) {
            int groupPrimary = (Integer)objects[0];
            int groupSecondary = (Integer)objects[1];
            int hour = (Integer)objects[2];
            int count = (Integer)objects[3];
            try {
                SaleReportRowCategory groupping = timeGroupingClass.getConstructor(Integer.TYPE, Integer.TYPE).newInstance(groupPrimary, groupSecondary);
                saleCounts.put((Object)groupping, (Object)hour, (Object)count);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalStateException("Cannot create time category", e);
            }
        }
        List dbResultSaleValues = this.entityManager.createNativeQuery("SELECT " + qsbGroups.toString() + " currency as res_currency, SUM (amount) as res_payment_amount FROM control.payment WHERE pdm_id IN (:pdmIds) AND pay_ts > '" + from.format(postgresDateTimeForamtter) + "' AND pay_ts < '" + to.format(postgresDateTimeForamtter) + "' AND pay_reason = '" + PaymentReason.PURCHASE.name() + "' GROUP BY res_group_major, res_group_minor, res_currency ORDER BY res_group_major, res_group_minor, res_currency").setParameter("pdmIds", pdmIds).getResultList();
        TreeBasedTable saleValues = TreeBasedTable.create();
        for (Object[] objects : dbResultSaleValues) {
            int year = (Integer)objects[0];
            int week = (Integer)objects[1];
            String currencyCode = (String)objects[2];
            BigDecimal value = (BigDecimal)objects[3];
            if (BigDecimal.ZERO.compareTo(value) == 0) continue;
            try {
                SaleReportRowCategory groupping = timeGroupingClass.getConstructor(Integer.TYPE, Integer.TYPE).newInstance(year, week);
                saleValues.put((Object)groupping, (Object)currencyCode, (Object)value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalStateException("Cannot create time category", e);
            }
        }
        return new SaleReport((Table)saleCounts, (Table)saleValues, from.toLocalDate(), to.toLocalDate(), timeGroupingClass);
    }

    public SaleReportByPdm calculateSalesByPdm(LocalDateTime from, LocalDateTime to, Collection<Pdm> pdms) {
        if (pdms.isEmpty()) {
            return new SaleReportByPdm();
        }
        ZoneId userTimeZoneId = this.i18nService.userTimeZoneId();
        this.entityManager.createNativeQuery("SET LOCAL TIME ZONE '" + userTimeZoneId.toString() + "'").executeUpdate();
        List dbResultSaleValues = this.paymentReportRepository.ticketSalePerPdm(pdms, OffsetDateTime.of(from, ZoneOffset.UTC), OffsetDateTime.of(to, ZoneOffset.UTC), PaymentReason.PURCHASE);
        SaleReportByPdm report = new SaleReportByPdm();
        dbResultSaleValues.forEach(obj -> report.addRow(obj.getCalYear(), obj.getCalWeek(), obj.getCalHour(), obj.getPdmId(), obj.getTicCount()));
        return report;
    }

    private /* synthetic */ void lambda$calculateAmount$1(ZoneId userTimeZone, Map collectors, CategoryStrategy rowCategoryStrategy, CategoryStrategy colCategoryStrategy, OccurenceCounter transactionCounter, PaymentTransaction pt) {
        this.entityManager.detach((Object)pt);
        LocalTime userTime = pt.getId().getPdmTime().atZoneSameInstant(userTimeZone).toLocalTime();
        collectors.computeIfAbsent(pt.getCurrency(), cs -> new TransactionCollectror(rowCategoryStrategy, colCategoryStrategy));
        TransactionCollectror collector = (TransactionCollectror)collectors.get(pt.getCurrency());
        collector.addData((Object)userTime, (Object)pt.getAmount());
        transactionCounter.increment((Object)pt.getCurrency());
    }
}

