/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers;

import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.ui.controllers.EntityNotAvailableException;
import de.rtb.pcon.ui.services.SecurityService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SecureEntityLoaderService {
    @PersistenceContext
    private EntityManager entityManager;
    private SecurityService securityService;

    public SecureEntityLoaderService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Transactional
    public Area loadArea(int id) {
        return this.securityService.getCurrentAreas().stream().filter(a -> a.getId() == id).findAny().orElseThrow(() -> this.makeException("area", id));
    }

    @Transactional
    public Zone loadZone(int id) {
        return this.securityService.getCurrentZones().stream().filter(a -> a.getId() == id).findAny().orElseThrow(() -> this.makeException("zone", id));
    }

    @Transactional
    public Pdm loadPdm(int id) {
        return this.securityService.getCurrentPdms().stream().filter(p -> p.getId() == id).findAny().orElseThrow(() -> this.makeException("PDM", id));
    }

    public void checkAreaAccessForCurrentUser(Area area) {
        if (this.securityService.deniedFor(area)) {
            throw new EntityNotAvailableException(HttpStatus.FORBIDDEN, "You do not have right to access area with id " + area.getId() + " .");
        }
    }

    public EntityNotAvailableException makeException(String objName, int objId) {
        return new EntityNotAvailableException(HttpStatus.NOT_FOUND, "The " + objName + " with id " + objId + " doesn't exist in the database or user " + this.securityService.getCurrentUserLogin() + " has no right to access it.");
    }
}

