/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.repositories.pdm;

import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.repositories.pdm.PdmPrincipalRepository;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import java.util.Optional;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Transactional;

public class PdmPrincipalRepositoryImpl
implements PdmPrincipalRepository {
    @PersistenceContext
    EntityManager em;

    @Transactional
    public List<Pdm> findAllByIdAllowed(Iterable<Integer> ids) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof AnonymousAuthenticationToken) {
            return List.of();
        }
        List pdms = this.em.createQuery("SELECT pdm FROM Pdm pdm JOIN pdm.zone.area a JOIN a.users u WHERE u IN (FROM User WHERE login = :login) AND pdm.id in (:ids)", Pdm.class).setParameter("login", (Object)authentication.getName()).setParameter("ids", ids).getResultList();
        return pdms;
    }

    @Transactional
    public Optional<Pdm> findByIdAllowed(int id) {
        List pdms = this.findAllByIdAllowed(List.of(Integer.valueOf(id)));
        if (pdms.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Pdm)pdms.get(0));
    }
}

