/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.model.download;

import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.download.DeviceType;
import de.rtb.pcon.model.download.DownloadPlan;
import de.rtb.pcon.model.download.SoftwarePath;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import org.hibernate.annotations.JdbcType;
import org.hibernate.dialect.PostgreSQLEnumJdbcType;

@Entity
@Table(name="software_description", schema="control")
public class SoftwareDescription {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="swd_id")
    private Integer id;
    @Column(name="swd_visible")
    private boolean visible;
    @Column(name="swd_file_name")
    private String fileName;
    @Column(name="swd_device_type", nullable=false, columnDefinition="\"control\".\"device_type\"\n")
    @Enumerated(value=EnumType.STRING)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    private DeviceType deviceType;
    @Column(name="swd_model")
    private String model;
    @Column(name="swd_version")
    private String version;
    @Column(name="swd_name")
    private String name;
    @Column(name="swd_note")
    private String note;
    @Column(name="swd_created")
    private OffsetDateTime timeCreated;
    @ManyToOne
    @JoinColumn(name="swd_area_id")
    private Area area;
    @ManyToOne
    @JoinColumn(name="swd_author_id")
    private User author;
    @OneToMany(mappedBy="softwareDescription")
    private List<SoftwarePath> softwarePaths;
    @OneToMany(mappedBy="softwareDescription")
    private List<DownloadPlan> plans;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String description) {
        this.note = description;
    }

    public OffsetDateTime getTimeCreated() {
        return this.timeCreated;
    }

    public void setTimeCreated(OffsetDateTime created) {
        this.timeCreated = created;
    }

    public Area getArea() {
        return this.area;
    }

    public void setArea(Area area) {
        this.area = area;
    }

    public List<SoftwarePath> getSoftwarePaths() {
        return this.softwarePaths;
    }

    public void setSoftwarePaths(List<SoftwarePath> softwarePaths) {
        this.softwarePaths = softwarePaths;
    }

    public User getAuthor() {
        return this.author;
    }

    public void setAuthor(User author) {
        this.author = author;
    }

    public List<DownloadPlan> getPlans() {
        return this.plans;
    }

    public void setPlans(List<DownloadPlan> plans) {
        this.plans = plans;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SoftwareDescription)) {
            return false;
        }
        SoftwareDescription other = (SoftwareDescription)obj;
        return Objects.equals(this.id, other.id);
    }
}

