/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.brain_behind;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.brain_behind.BalanceRequestBrbDto;
import de.rtb.pcon.features.partners.brain_behind.BrainBehindUtilService;
import de.rtb.pcon.features.partners.brain_behind.BrbConfigurationService;
import de.rtb.pcon.features.partners.brain_behind.BrbRequestConfigDto;
import de.rtb.pcon.features.partners.brain_behind.CardBrbDto;
import de.rtb.pcon.features.partners.brain_behind.CardBrbWDto;
import de.rtb.pcon.features.partners.brain_behind.CardPdmDto;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.Pdm;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.UnknownContentTypeException;

@Component
class BrbRtrBalance
implements RealTimeRequest {
    private static final Logger log = LoggerFactory.getLogger(BrbRtrBalance.class);
    private final RestTemplate restTemplate;
    private final BrainBehindUtilService bbUtilsService;
    private final BrbConfigurationService configService;

    public BrbRtrBalance(@Qualifier(value="rt3rdPartyApi") RestTemplate restTemplate, BrainBehindUtilService bbUtilsService, BrbConfigurationService configService) {
        this.restTemplate = restTemplate;
        this.bbUtilsService = bbUtilsService;
        this.configService = configService;
    }

    public int getId() {
        return 22;
    }

    public String getDescription() {
        return "Brain behind, accounts";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        String cardNumber = ctx.getLocalString("KNN");
        Pdm pdm = ctx.global().getPdm();
        Area area = ctx.global().getPdm().getZone().getArea();
        HashMap<String, Object> result = new HashMap<String, Object>();
        BrbRequestConfigDto config = (BrbRequestConfigDto)this.configService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("provider", config.user());
        headers.set("password", config.passwordWeb());
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        BalanceRequestBrbDto balanceRequest = new BalanceRequestBrbDto(cardNumber, BrbConfigurationService.makeTerminalId((Pdm)pdm));
        HttpEntity postEntity = new HttpEntity((Object)balanceRequest, (MultiValueMap)headers);
        try {
            URI uri = BrbConfigurationService.createServiceUri((String)config.urlPrefix(), (String)"CU_Check_Balance_Array");
            CardBrbWDto cardBbW = (CardBrbWDto)this.restTemplate.postForObject(uri, (Object)postEntity, CardBrbWDto.class);
            if (cardBbW == null || cardBbW.d() == null) {
                result.put("ERC", 2);
                result.put("ERM", "Response is empty");
            } else {
                CardBrbDto cardBb = cardBbW.d();
                if (cardBb.errorCode().isEmpty()) {
                    CardPdmDto cardPdm = CardPdmDto.of((CardBrbDto)cardBb, (int)ctx.getMonetaryScale());
                    result.put("BAL", cardPdm);
                    result.put("DPA", ctx.getMonetaryScale());
                } else {
                    result.put("ERC", 4);
                    StringBuilder msg = new StringBuilder();
                    cardBb.errorMessage().ifPresent(msg::append);
                    cardBb.errorCode().ifPresent(m -> msg.append(" [" + m + "]."));
                    result.put("ERM", msg);
                }
            }
        }
        catch (HttpServerErrorException.InternalServerError e) {
            log.error("Brain behind server error.", (Throwable)e);
            result.putAll(this.bbUtilsService.mapInternalServerError(e));
        }
        catch (RestClientException e) {
            UnknownContentTypeException e1 = (UnknownContentTypeException)e;
            log.info("Response {}", (Object)e1.getResponseBodyAsString());
            log.error("Error occurred in communication with brain behind.", (Throwable)e);
            result.put("ERC", 3);
        }
        return result;
    }
}

