/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.card_id;

import de.rtb.pcon.features.bonus.BonusUtils;
import de.rtb.pcon.features.bonus.card_id.BonIdRuleEntity;
import de.rtb.pcon.features.bonus.card_id.BonIdRuleRepository;
import de.rtb.pcon.features.bonus.card_id.BonIdService;
import de.rtb.pcon.features.bonus.card_id.BonIdTypeDtoUi;
import de.rtb.pcon.features.bonus.card_id.BonIdTypeEntity;
import de.rtb.pcon.features.bonus.card_id.BonIdTypeReposiory;
import de.rtb.pcon.features.bonus.utils.CronUtils;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelImportException;
import de.rtb.pcontrol.utils.LoggerUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.server.ResponseStatusException;

@Service
class BonIdService {
    private static final Logger logger = LoggerFactory.getLogger(BonIdService.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private BonIdRuleRepository bonusRuleRepo;
    @Autowired
    private BonIdTypeReposiory bonusTypeRepo;
    @Autowired
    private I18nService i18nService;

    BonIdService() {
    }

    @Transactional
    public synchronized boolean doBonusResetIfNeeded(BonIdTypeEntity bon) {
        if (StringUtils.isBlank((CharSequence)bon.getCronResetPattern())) {
            return false;
        }
        Function<String, OffsetDateTime> calculateNextBonusReset = cronPattern -> CronUtils.nextExecutoinAfterNow((String)cronPattern).map(ZonedDateTime::toOffsetDateTime).orElseThrow();
        if (bon.getNextReset() == null) {
            bon.setNextReset(calculateNextBonusReset.apply(bon.getCronResetPattern()));
        }
        if (OffsetDateTime.now().isAfter(bon.getNextReset())) {
            OffsetDateTime nextReset = calculateNextBonusReset.apply(bon.getCronResetPattern());
            if (logger.isInfoEnabled()) {
                logger.info("ID bonus #{} in {} was reset. Last reset {}, next reset {}, pattern '{}'", new Object[]{bon.getName(), LoggerUtils.log((Zone)bon.getZone()), bon.getNextReset(), nextReset, bon.getCronResetPattern()});
            }
            bon.setNextReset(nextReset);
            this.bonusRuleRepo.resetUsedCount(bon);
            return true;
        }
        return false;
    }

    public static Integer getTariffIndex(BonIdRuleEntity rule, Pdm pdm) {
        Integer n;
        switch (1.$SwitchMap$de$rtb$pcon$features$bonus$card_id$BonIdTariffIdMode[rule.getType().getMode().ordinal()]) {
            default: {
                throw new MatchException(null, null);
            }
            case 1: {
                try {
                    Integer n2;
                    n = n2 = Integer.valueOf(Integer.parseInt(rule.getTariff()));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("Cannot use text '" + rule.getTariff() + "' as tariff index.");
                }
            }
            case 2: {
                Integer n3;
                n = n3 = BonusUtils.findTariffIndexByTariffName((String)rule.getTariff(), (Pdm)pdm);
            }
        }
        return n;
    }

    @Transactional(readOnly=true)
    public List<BonIdTypeDtoUi> listBonusTypes(Zone zone) {
        return this.bonusTypeRepo.findByZone(zone).stream().map(BonIdTypeDtoUi::fromEntity).toList();
    }

    @Transactional
    public Optional<BonIdTypeEntity> findType(Integer id) {
        return this.bonusTypeRepo.findById((Object)id);
    }

    @Transactional
    public Optional<BonIdTypeEntity> findType(Zone zone, String key) {
        return this.bonusTypeRepo.findByZoneAndName(zone, key);
    }

    @Transactional
    public void deleteType(BonIdTypeEntity entity) {
        this.bonusTypeRepo.delete((Object)entity);
    }

    @Transactional
    public BonIdTypeEntity createOrUpdateBonusType(BonIdTypeDtoUi bonusTypeUi, Zone zone) {
        BonIdTypeEntity bonusTypeEntity = null;
        if (bonusTypeUi.getId() != null) {
            Optional cardTypeEntO = this.findType(bonusTypeUi.getId());
            if (cardTypeEntO.isEmpty() || !zone.equals((Object)((BonIdTypeEntity)cardTypeEntO.get()).getZone())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
            }
            bonusTypeEntity = (BonIdTypeEntity)cardTypeEntO.orElseThrow();
        } else {
            bonusTypeEntity = new BonIdTypeEntity();
            bonusTypeEntity.setZone(zone);
            bonusTypeEntity.setMode(bonusTypeUi.getMode());
        }
        Optional bonusTypeWithSameName = this.findType(zone, bonusTypeUi.getName());
        if (bonusTypeWithSameName.isPresent() && !Objects.equals(bonusTypeWithSameName.orElseThrow(), bonusTypeEntity)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT);
        }
        bonusTypeEntity.setName(bonusTypeUi.getName());
        String cronPattern = StringUtils.trim((String)bonusTypeUi.getResetPattern());
        if (StringUtils.isBlank((CharSequence)cronPattern)) {
            bonusTypeEntity.setCronResetPattern(null);
        } else {
            try {
                CronUtils.CRON_PARSER.parse(cronPattern).validate();
                bonusTypeEntity.setCronResetPattern(cronPattern);
                bonusTypeEntity.setNextReset(null);
            }
            catch (IllegalArgumentException e) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE);
            }
        }
        bonusTypeEntity.setDescription(bonusTypeUi.getDescription());
        bonusTypeEntity.setMaxIssues(bonusTypeUi.getMaxIssues());
        return (BonIdTypeEntity)this.bonusTypeRepo.save((Object)bonusTypeEntity);
    }

    @Transactional
    public int cleanBonusType(BonIdTypeEntity cardType) {
        return this.bonusRuleRepo.deleteByType(cardType);
    }

    @Transactional(rollbackFor={ExcelImportException.class})
    public int importExcelData(Sheet sheet, Zone zone, BonIdTypeEntity bonusType) throws ExcelImportException {
        logger.debug("Importing data for '{}'.", (Object)bonusType.getName());
        int rowNumber = 0;
        int colNumber = 0;
        int ruleCount = 0;
        ZoneId userTimeZone = this.i18nService.userTimeZoneId();
        try {
            for (Row row : sheet) {
                rowNumber = row.getRowNum();
                if (!this.rowHasData(row)) continue;
                ++ruleCount;
                BonIdRuleEntity sbd = new BonIdRuleEntity();
                colNumber = 0;
                sbd.setKey(StringUtils.upperCase((String)this.extractCellValueAsString(row.getCell(colNumber++), () -> "Invalid bonus ID")));
                sbd.setTariff(this.extractCellValueAsString(row.getCell(colNumber++), () -> "Invalid tariff index"));
                Optional.ofNullable(row.getCell(colNumber++)).ifPresent(c -> {
                    OffsetDateTime dtm = c.getLocalDateTimeCellValue().atZone(userTimeZone).toOffsetDateTime();
                    sbd.setExpiration(dtm);
                });
                sbd.setType(bonusType);
                sbd.setUsedTimes(Integer.valueOf(0));
                this.bonusRuleRepo.save((Object)sbd);
                this.entityManager.detach((Object)sbd);
            }
            logger.debug("Import complete.");
            return ruleCount;
        }
        catch (Exception e) {
            throw new ExcelImportException(rowNumber, colNumber, (Throwable)e);
        }
    }

    String extractCellValueAsString(Cell cell, Supplier<String> exceptionText) {
        return switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
            case 1 -> cell.getStringCellValue();
            case 2 -> {
                double num = cell.getNumericCellValue();
                if (num == (double)((int)num)) {
                    yield Integer.toString((int)num);
                }
                throw new IllegalStateException(exceptionText.get() + ": '" + num + "'. It must be either text or whole number.");
            }
            default -> throw new IllegalArgumentException("Unexpected cell type: " + String.valueOf(cell.getCellType()) + ". It must be either STRING\t or NUMERIC.");
        };
    }

    boolean rowHasData(Row row) {
        short requiredNumberOfCells = 2;
        if (row.getLastCellNum() < requiredNumberOfCells) {
            logger.info("The row {} is skipped because it contains only {} cells from {} required.", new Object[]{row.getRowNum() + 1, row.getLastCellNum(), (int)requiredNumberOfCells});
            return false;
        }
        Iterator rowIt = row.cellIterator();
        while (rowIt.hasNext()) {
            Cell cell = (Cell)rowIt.next();
            if (cell == null || cell.getCellType() == CellType.BLANK) continue;
            return true;
        }
        logger.info("The row {} is skipped because all cells are blank.", (Object)(row.getRowNum() + 1));
        return false;
    }
}

