/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus;

import de.rtb.pcon.features.bonus.AppliedBonus;
import de.rtb.pcon.features.bonus.AppliedBonusKind;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.zone.Zone;
import jakarta.persistence.Tuple;
import java.time.OffsetDateTime;
import java.util.List;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;

public interface AppliedBonusRepository
extends CrudRepository<AppliedBonus, Integer> {
    @Query(value="FROM PaymentTransaction p\nJOIN FETCH p.bonus b\nWHERE\n  b.kind = :kind\n  AND b.payment.lpn = :lpn\n  AND b.payment.id.pdmTime > :after\n  AND b.payment.id.pdm.zone.area = :area")
    public List<PaymentTransaction> findUsedBonuses(@Param(value="kind") AppliedBonusKind var1, @Param(value="lpn") String var2, @Param(value="after") OffsetDateTime var3, @Param(value="area") Area var4);

    @Query(value="FROM AppliedBonus b\nJOIN FETCH b.payment\nWHERE\n  b.kind = :kind\n  AND b.payment.id.pdmTime > :after\n  AND b.payment.id.pdm.zone = :zone")
    public List<AppliedBonus> findAllByKindAndAreaAfter(@Param(value="kind") AppliedBonusKind var1, @Param(value="after") OffsetDateTime var2, @Param(value="zone") Zone var3);

    @Query(value="FROM AppliedBonus b\nJOIN FETCH b.payment\nWHERE\n  b.kind = :kind\n  AND b.payment.id.pdmTime > :after\n  AND b.payment.parkEndTime > :now\n  AND b.payment.id.pdm.zone = :zone")
    public List<AppliedBonus> findActiveByKindAndAreaAfter(@Param(value="kind") AppliedBonusKind var1, @Param(value="after") OffsetDateTime var2, @Param(value="now") OffsetDateTime var3, @Param(value="zone") Zone var4);

    @Query(value="SELECT COUNT(ab) AS cnt, COALESCE (SUM(ab.duration), 0) as dur\nFROM AppliedBonus ab\nWHERE\n  ab.kind = :kind\n  AND ab.payment.id.pdmTime > :after\n  AND ab.payment.id.pdm.zone = :zone")
    public Tuple sumarizeUsedBonuses(@Param(value="kind") AppliedBonusKind var1, @Param(value="after") OffsetDateTime var2, @Param(value="zone") Zone var3);
}

