/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.msg_presistence;

import de.rtb.pcon.core.msg_presistence.PaymentTransactionPersitenceService;
import de.rtb.pcon.core.msg_presistence.PaymentTransactionService;
import de.rtb.pcon.core.msg_presistence.payment.cpf.CustomPaymentFieldService;
import de.rtb.pcon.core.real_time_parking.RealTimeParkingService;
import de.rtb.pcon.core.runtime_monitor.TariffService;
import de.rtb.pcon.core.services.pdm_in.ExtensiblePermitDbId;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.PaymentTransactionId;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.TariffInfo;
import de.rtb.pcon.repositories.PaymentTransactionRepository;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PaymentTransactionService {
    private static final Logger log = LoggerFactory.getLogger(PaymentTransactionService.class);
    @Autowired
    private PdmRepository pdmRepository;
    @Autowired
    private CustomPaymentFieldService cpfService;
    @Autowired
    private RealTimeParkingService rtpService;
    @Autowired
    private PaymentTransactionRepository paymentTrasactionRepo;
    @Autowired
    private PaymentTransactionPersitenceService paymentPersistenceService;

    public PaymentTransaction process(PdmMessageDto msg) {
        PaymentTransaction payment = PaymentTransactionService.mapPdmTransactionMessage((PdmMessageDto)msg);
        this.savePayment(payment);
        if (StringUtils.isNotBlank((CharSequence)msg.getPti())) {
            this.rtpService.registerRtp(payment, msg.getPti());
        }
        return payment;
    }

    public PaymentTransaction savePayment(PaymentTransaction payment) {
        this.paymentPersistenceService.insertToDb(payment);
        return payment;
    }

    @Transactional
    public void processCustomPaymentField(PdmMessageDto m) {
        Optional.ofNullable(m.getCpf()).ifPresent(v -> this.cpfService.modifyCpf(m.getPdm(), v));
    }

    @Transactional
    public PaymentTransaction persistParkingTicketExtension(PdmMessageDto m) {
        ExtensiblePermitDbId eid = (ExtensiblePermitDbId)m.getEid().orElseThrow();
        PaymentTransactionId originalPaymentId = new PaymentTransactionId((Pdm)this.pdmRepository.getReferenceById((Object)eid.pdmId()), eid.payTs().atOffset(ZoneOffset.UTC), eid.tracer());
        PaymentTransaction originalPayment = this.paymentTrasactionRepo.findById((Object)originalPaymentId).orElse(null);
        TariffInfo tariffInfo = null;
        OffsetDateTime originalParkingEnd = null;
        if (originalPayment != null) {
            originalParkingEnd = originalPayment.getParkEndTime();
            originalPayment.setParkEndTime(m.getParkEnd());
            tariffInfo = originalPayment.getTariffInfo();
            if (originalPayment.getBasePermit() == null) {
                originalPayment.setBasePermit(originalPayment);
            }
        } else {
            log.error("Required payment #{} to extend was not found.", (Object)m.getEid());
        }
        if (tariffInfo == null) {
            tariffInfo = TariffService.findTariffInfo((Pdm)m.getPdm(), (Integer)m.getTid());
        }
        PaymentTransaction extendingPayment = PaymentTransactionService.mapPdmTransactionMessage((PdmMessageDto)m);
        if (originalParkingEnd != null) {
            extendingPayment.getId().setPdmTime(originalParkingEnd);
        } else {
            log.warn("Base permit to extend was not found. Start time of this parking permit is not aligned with parking end of base permit.");
        }
        extendingPayment.setTariffInfo(tariffInfo);
        BigDecimal parkingAmount = m.getBep() == null ? m.getBet() : m.getBet().subtract(m.getBep());
        extendingPayment.setAmount(parkingAmount);
        extendingPayment.setPaymentReason(PaymentReason.PERMIT_EXTENSION);
        extendingPayment.setBasePermit(originalPayment);
        this.savePayment(extendingPayment);
        if (m.getBep() != null) {
            PaymentTransaction penaltyPayment = PaymentTransactionService.mapPdmPaymentPenalty((PdmMessageDto)m);
            this.savePayment(penaltyPayment);
        }
        return extendingPayment;
    }

    static final PaymentTransaction mapPdmTransactionMessage(PdmMessageDto msg) {
        PaymentTransaction pay = new PaymentTransaction();
        pay.setId(new PaymentTransactionId(msg.getPdm(), msg.getDatTim(), msg.getTrc()));
        pay.setServerTime(DateTimeUtils.serverNowO());
        pay.setPaymentReason(msg.getStp());
        pay.setPaymentType(msg.getBza());
        if (msg.getUst() != null) {
            switch (1.$SwitchMap$de$rtb$pcon$model$PaymentUserType[msg.getUst().ordinal()]) {
                case 1: {
                    pay.setPaymentReason(PaymentReason.ZERO_TICKET);
                    break;
                }
                case 2: {
                    pay.setPaymentReason(PaymentReason.JETON);
                    break;
                }
            }
        }
        pay.setAmount(msg.getBet());
        if (msg.getParkEnd() != null) {
            pay.setParkEndTime(msg.getParkEnd());
        } else {
            pay.setParkEndTime(null);
        }
        pay.setTicketNumber(msg.getTin().intValue());
        if (msg.getStp() == PaymentReason.RECONCILIATION) {
            pay.setPaymentCode(null);
        } else {
            pay.setPaymentCode(msg.getZid());
        }
        pay.setCurrency(msg.getWkz());
        pay.setCardType(msg.getTyp());
        pay.setLpn(msg.getLcn());
        pay.setSpecialCode(msg.getSke());
        pay.setPsn(msg.getPan());
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{msg.getAth()}) && StringUtils.isEmpty((CharSequence)msg.getTrf())) {
            pay.setAuthCode(msg.getAth());
        } else if (StringUtils.isEmpty((CharSequence)msg.getAth()) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{msg.getTrf()})) {
            pay.setAuthCode(msg.getTrf());
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{msg.getAth()}) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{msg.getTrf()})) {
            throw new IllegalStateException("Only one of ATH or TRF codes can be present.");
        }
        pay.setTariffInfo(TariffService.findTariffInfo((Pdm)msg.getPdm(), (Integer)msg.getTid()));
        return pay;
    }

    static final PaymentTransaction mapPdmPaymentPenalty(PdmMessageDto msg) {
        PaymentTransaction pay = new PaymentTransaction();
        pay.setId(new PaymentTransactionId(msg.getPdm(), msg.getDatTim(), msg.getTrc()));
        pay.setServerTime(DateTimeUtils.serverNowO());
        pay.setPaymentReason(PaymentReason.PENALTY);
        pay.setPaymentType(msg.getBza());
        pay.setAmount(msg.getBep());
        pay.setTicketNumber(msg.getTin().intValue());
        pay.setCurrency(msg.getWkz());
        if (msg.getStp() == PaymentReason.RECONCILIATION) {
            pay.setPaymentCode(null);
        } else {
            pay.setPaymentCode(msg.getZid());
        }
        pay.setLpn(msg.getLcn());
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{msg.getAth()}) && StringUtils.isEmpty((CharSequence)msg.getTrf())) {
            pay.setAuthCode(msg.getAth());
        } else if (StringUtils.isEmpty((CharSequence)msg.getAth()) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{msg.getTrf()})) {
            pay.setAuthCode(msg.getTrf());
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{msg.getAth()}) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{msg.getTrf()})) {
            throw new IllegalStateException("Only one of ATH or TRF codes can be present.");
        }
        return pay;
    }
}

