/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.user_profile;

import de.rtb.pcon.core.events.UserUpdatedEvent;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.ui.controllers.user_profile.UiUserProfile;
import de.rtb.pcon.ui.controllers.user_profile.UiUserProfileInfo;
import de.rtb.pcon.ui.controllers.user_profile.UiUserProfilePassword;
import de.rtb.pcon.ui.services.SecurityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pcon/ui/user-profile"})
public class UserProfileController {
    @Autowired
    private SecurityService securityService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private PasswordEncoder passwordEncoder;

    @GetMapping(value={"info"})
    public UiUserProfileInfo getUserProfileInfo() {
        return new UiUserProfileInfo(this.securityService.getCurrentUser());
    }

    @PutMapping(value={"properties"})
    @Transactional
    public void setUserProfile(@RequestBody UiUserProfile uiProfile) {
        User user = this.securityService.getCurrentUser();
        user.setFirstName(uiProfile.getFirstName());
        user.setLastName(uiProfile.getLastName());
        user.setEmail(uiProfile.getEmail());
        user.setTimeZoneName(uiProfile.getTimeZone());
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserUpdatedEvent((Object)this, user.getId().intValue()));
    }

    @PutMapping(value={"password"})
    @Transactional
    public ResponseEntity<Object> setUserPassword(@RequestBody UiUserProfilePassword pass) {
        User user = this.securityService.getCurrentUser();
        boolean pwdOk = this.passwordEncoder.matches((CharSequence)pass.getOldPwd(), user.getPasswordHash());
        if (!pwdOk) {
            return ResponseEntity.status((int)213).build();
        }
        user.setPasswordHash(this.passwordEncoder.encode((CharSequence)pass.getNewPwd()));
        return ResponseEntity.ok().build();
    }
}

