/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.dashboard;

import de.rtb.pcon.core.cash_box.CashBoxMonitorService;
import de.rtb.pcon.model.AlertType;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import de.rtb.pcon.ui.controllers.dashboard.DashboardRepository;
import de.rtb.pcon.ui.controllers.dashboard.RevenueByDayDto;
import de.rtb.pcon.ui.controllers.model.UiChartCollector;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.services.PdmService;
import de.rtb.pcon.ui.services.SecurityService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pcon/ui/overview"})
class DashboardController {
    private static final List<PaymentReason> REVENUE_PAYMENT_RESONS = List.of(PaymentReason.PURCHASE, PaymentReason.RTP_LOGOFF, PaymentReason.RTP_FORCED_LOGOFF, PaymentReason.RTP);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PdmService pdmService;
    @Autowired
    private I18nService i18nService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private CashBoxMonitorService cachedLevelBoxService;
    @Autowired
    private PdmRepository pdmRepo;
    @Autowired
    private DashboardRepository dashboardRepository;

    DashboardController() {
    }

    @PreAuthorize(value="hasRole('ROLE_PCON_SERVICE')")
    @GetMapping(value={"alerts.json"})
    public Map<String, Integer> getPdmAlerts() {
        Map issueMap = this.pdmService.countPdmsWithIssue();
        return issueMap.entrySet().stream().collect(Collectors.toMap(e -> ((AlertType)e.getKey()).toString().toLowerCase(), Map.Entry::getValue));
    }

    @PreAuthorize(value="hasRole('ROLE_PCON_ECONOMIST')")
    @GetMapping(value={"revenue/lastWeek/byDay"})
    @Transactional(readOnly=true)
    public UiChartCollector.ChartData getWeeklyRevenue() {
        List userPdms = this.securityService.getCurrentPdms();
        ZoneId userTimeZone = this.i18nService.userTimeZoneId();
        Locale userLocale = this.i18nService.getUserLocale();
        OffsetDateTime endOfReport = this.endOfRevenueChart(userTimeZone);
        OffsetDateTime startOfReport = this.startOfRevenueChart(endOfReport);
        this.entityManager.createNativeQuery("SET LOCAL TIME ZONE '" + userTimeZone.toString() + "'").executeUpdate();
        List revenueData = this.dashboardRepository.fetchRevenueForPdmsByDay((Collection)userPdms, startOfReport, endOfReport, REVENUE_PAYMENT_RESONS);
        return this.createChartDateByDayOfWeek(revenueData, userLocale, endOfReport.toLocalDate());
    }

    @PreAuthorize(value="hasRole('ROLE_PCON_ECONOMIST')")
    @GetMapping(value={"revenue/lastWeek/byDay/top10"})
    @Transactional(readOnly=true)
    public UiChartCollector.ChartData getWeeklyRevenueTopTen() {
        List userAreas = this.securityService.getCurrentAreas();
        ZoneId userTimeZone = this.i18nService.userTimeZoneId();
        Locale userLocale = this.i18nService.getUserLocale();
        OffsetDateTime endOfReport = this.endOfRevenueChart(userTimeZone);
        OffsetDateTime startOfReport = this.startOfRevenueChart(endOfReport);
        this.entityManager.createNativeQuery("SET LOCAL TIME ZONE '" + this.i18nService.userTimeZoneId().toString() + "'").executeUpdate();
        List topTenSellingPdms = this.dashboardRepository.findTopSellingPdm((Collection)userAreas, startOfReport, endOfReport, (Collection)REVENUE_PAYMENT_RESONS, Pageable.ofSize((int)10)).toList();
        List revenueData = this.dashboardRepository.fetchRevenueForPdmsByDay((Collection)topTenSellingPdms, startOfReport, endOfReport, REVENUE_PAYMENT_RESONS);
        return this.createChartDateByDayOfWeek(revenueData, userLocale, endOfReport.toLocalDate());
    }

    private UiChartCollector.ChartData createChartDateByDayOfWeek(List<RevenueByDayDto> revenueData, Locale userLocale, LocalDate startOfChart) {
        UiChartCollector chartData = new UiChartCollector((Object)0.0);
        HashMap revenue = new HashMap();
        revenueData.stream().forEach(r -> {
            HashMap curRecord = revenue.computeIfAbsent(r.getCurrency(), k -> new HashMap());
            BigDecimal dayRevenue = curRecord.computeIfAbsent(r.getDate(), k -> BigDecimal.ZERO);
            curRecord.put(r.getDate(), dayRevenue.add(r.getRevenue()));
        });
        List<String> daysInChart = IntStream.range(1, 7).mapToObj(startOfChart::minusDays).map(d -> d.getDayOfWeek().getDisplayName(TextStyle.SHORT, userLocale)).toList();
        chartData.enforceCategories(daysInChart);
        for (Map.Entry currencyGroup : revenue.entrySet()) {
            String currency = (String)currencyGroup.getKey();
            HashMap dayRevenue = (HashMap)currencyGroup.getValue();
            for (Map.Entry dayGroup : dayRevenue.entrySet()) {
                chartData.addValue(currency, (Object)((LocalDate)dayGroup.getKey()).getDayOfWeek().getDisplayName(TextStyle.SHORT, userLocale), (Object)((BigDecimal)dayGroup.getValue()).doubleValue());
            }
        }
        return chartData.build();
    }

    @PreAuthorize(value="hasRole('ROLE_PCON_ECONOMIST')")
    @GetMapping(value={"revenue/coinBoxLevels"})
    @Transactional(readOnly=true)
    public Map<String, Object> getCoinBoxLevels() {
        List userAreas = this.securityService.getCurrentAreas();
        List pdms = this.pdmRepo.findByArea((Collection)userAreas);
        UiChartCollector chartData = new UiChartCollector((Object)BigDecimal.ZERO);
        this.cachedLevelBoxService.findForPdms((Collection)pdms).stream().sorted((c1, c2) -> c2.getLevel().compareTo(c1.getLevel())).limit(10L).forEach(cbl -> chartData.addValue(cbl.getCurrency(), (Object)(cbl.getPdm().getNumber() + "@" + cbl.getPdm().getZone().getArea().getId()), (Object)cbl.getLevel()));
        return chartData.build();
    }

    @PreAuthorize(value="hasRole('ROLE_PCON_ECONOMIST')")
    @GetMapping(value={"purchase/byHour/all"})
    @Transactional
    public Object calculatePurchaseByHour() {
        List userAreas = this.securityService.getCurrentAreas();
        UiChartCollector chartData = new UiChartCollector((Object)0L);
        this.entityManager.createNativeQuery("SET LOCAL TIME ZONE '" + this.i18nService.userTimeZoneId().toString() + "'").executeUpdate();
        chartData.enforceCategories((Collection)IntStream.rangeClosed(0, 23).boxed().collect(Collectors.toSet()));
        this.dashboardRepository.fetchSaleCountsByHour((Collection)userAreas, OffsetDateTime.now().minusDays(7L), REVENUE_PAYMENT_RESONS).forEach(h -> chartData.addValue(h.currency(), (Object)h.hour(), (Object)h.count()));
        return chartData.build();
    }

    private OffsetDateTime endOfRevenueChart(ZoneId timeZone) {
        return ZonedDateTime.now(timeZone).truncatedTo(ChronoUnit.DAYS).toOffsetDateTime();
    }

    private OffsetDateTime startOfRevenueChart(OffsetDateTime endDate) {
        return endDate.minusDays(7L);
    }
}

