/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers;

import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import de.rtb.pcon.ui.controllers.GisController;
import de.rtb.pcon.ui.controllers.PdmFilterRepository;
import de.rtb.pcon.ui.controllers.model.filter.FilterPdmInclusive;
import de.rtb.pcon.ui.services.SecurityService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.geojson.Feature;
import org.geojson.FeatureCollection;
import org.geojson.GeoJsonObject;
import org.geojson.Point;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pcon/ui/gis"})
public class GisController {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private PdmFilterRepository pdmFilterRepository;
    @Autowired
    private PdmRepository pdmRepo;

    @PreAuthorize(value="isAuthenticated()")
    @GetMapping(value={"area/{id}/pdms"})
    public Object getAreaPdmLocations(@PathVariable(value="id") int areaId) {
        List areas = this.entityManager.createQuery("FROM Area a\nJOIN FETCH a.pdms\nWHERE a.id = :areaId", Area.class).setParameter("areaId", (Object)areaId).getResultList();
        if (areas.isEmpty()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        Area area = (Area)areas.get(0);
        if (this.securityService.deniedFor(area)) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        return this.makePdmFeatureCollection((Collection)this.pdmRepo.findByArea(area));
    }

    @PreAuthorize(value="isAuthenticated()")
    @GetMapping(value={"zone/{id}/pdms"})
    @Transactional
    public Object getZonePdmLocations(@PathVariable(value="id") int zoneId) {
        List zones = this.entityManager.createQuery("FROM Zone zone\nJOIN FETCH zone.pdms\nWHERE zone.id = :zoneId", Zone.class).setParameter("zoneId", (Object)zoneId).getResultList();
        if (zones.isEmpty()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        Zone zone = (Zone)zones.get(0);
        Area area = zone.getArea();
        if (this.securityService.deniedFor(area)) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        return this.makePdmFeatureCollection((Collection)zone.getPdms());
    }

    @PreAuthorize(value="isAuthenticated()")
    @GetMapping(value={"pdm/{id}"})
    @Transactional
    public ResponseEntity<FeatureCollection> getPdmLocation(@PathVariable(value="id") int pdmId) {
        List pdms = this.entityManager.createQuery("SELECT pdm\nFROM Pdm pdm\nJOIN FETCH pdm.area\nWHERE pdm.id = :pdmId\n", Pdm.class).setParameter("pdmId", (Object)pdmId).getResultList();
        if (pdms.isEmpty()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        Area area = ((Pdm)pdms.get(0)).getZone().getArea();
        if (this.securityService.deniedFor(area)) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        return new ResponseEntity((Object)this.makePdmFeatureCollection((Collection)pdms), (HttpStatusCode)HttpStatus.OK);
    }

    @PreAuthorize(value="isAuthenticated()")
    @PostMapping(path={"pdm/{id}"}, consumes={"application/json"})
    @Transactional
    public ResponseEntity<Object> setPdmLocation(@PathVariable(value="id") int pdmId, @RequestBody BodyCoordinates coordinates) {
        List pdms = this.entityManager.createQuery("SELECT pdm\nFROM Pdm pdm\nJOIN FETCH pdm.area\nWHERE pdm.id = :pdmId\n", Pdm.class).setParameter("pdmId", (Object)pdmId).getResultList();
        if (pdms.isEmpty()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        Area area = ((Pdm)pdms.get(0)).getZone().getArea();
        if (this.securityService.deniedFor(area)) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        throw new NotImplementedException("The method is not yet implemented.");
    }

    @PreAuthorize(value="isAuthenticated()")
    @GetMapping(value={"pdms"})
    @Transactional
    public Object getPdmsLocation(@RequestParam(name="area", required=false) Set<Integer> uiAreaIds, @RequestParam(name="zone", required=false) Set<Integer> uiZoneIds, @RequestParam(name="pdm", required=false) Set<Integer> uiPdmIds) {
        FilterPdmInclusive pdmFilter = new FilterPdmInclusive(uiAreaIds, uiZoneIds, uiPdmIds);
        List pdms = this.pdmFilterRepository.findPdmsByInclusiveFilter(pdmFilter);
        List pdmsWithCoordinates = this.entityManager.createQuery("FROM Pdm p WHERE   latitude is not null AND   longitude is not null AND p in (:pdms)", Pdm.class).setParameter("pdms", (Object)pdms).getResultList();
        return this.makePdmFeatureCollection((Collection)pdmsWithCoordinates);
    }

    public FeatureCollection makePdmFeatureCollection(Collection<Pdm> pdms) {
        FeatureCollection featureCollection = new FeatureCollection();
        for (Pdm pdm : pdms) {
            if (pdm.getLatitude() == null || pdm.getLongitude() == null) continue;
            Feature feature = new Feature();
            feature.setGeometry((GeoJsonObject)new Point(pdm.getLongitude().doubleValue(), pdm.getLatitude().doubleValue()));
            feature.setProperty("id", (Object)pdm.getId());
            featureCollection.add(feature);
        }
        return featureCollection;
    }
}

