/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.pagopa;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.springframework.ws.client.WebServiceClientException;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.transport.context.TransportContext;
import org.springframework.ws.transport.context.TransportContextHolder;
import org.springframework.ws.transport.http.HttpComponentsConnection;

class BasicAuthInterceptor
implements ClientInterceptor {
    private final String authHeader;

    public BasicAuthInterceptor(String username, String password) {
        String token = Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
        this.authHeader = "Basic " + token;
    }

    public boolean handleRequest(MessageContext messageContext) throws WebServiceClientException {
        TransportContext context = TransportContextHolder.getTransportContext();
        HttpComponentsConnection conn = (HttpComponentsConnection)context.getConnection();
        try {
            conn.addRequestHeader("Authorization", this.authHeader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        return true;
    }

    public boolean handleFault(MessageContext messageContext) {
        return true;
    }

    public void afterCompletion(MessageContext messageContext, Exception ex) throws WebServiceClientException {
    }
}

