/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.hks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.hks.HksConfigDto;
import de.rtb.pcon.features.partners.hks.HksConfigService;
import de.rtb.pcon.features.partners.hks.HksRtrSellCart;
import de.rtb.pcon.model.Area;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;

@Component
class HksRtrSellCart
implements RealTimeRequest {
    private final RestClient restClient;
    private final HksConfigService hksConfigService;

    public HksRtrSellCart(@Qualifier(value="wc3rdPartyApi") RestClient restClient, HksConfigService hksConfigService) {
        this.restClient = restClient;
        this.hksConfigService = hksConfigService;
    }

    public int getId() {
        return 39;
    }

    public String getDescription() {
        return "HKS, sell cart";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Area area = ctx.global().getPdm().getZone().getArea();
        HksConfigDto config = (HksConfigDto)this.hksConfigService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        DtoHksCartReq cart = (DtoHksCartReq)ctx.getLocalObject(DtoHksCartReq.class);
        try {
            String cartStr = new ObjectMapper().writeValueAsString((Object)cart);
            URI saleUri = UriComponentsBuilder.fromUriString((String)config.baseUrl()).pathSegment(new String[]{"pos", "sale"}).build().toUri();
            String auth = "Basic " + HttpHeaders.encodeBasicAuth((String)config.user(), (String)config.password(), (Charset)StandardCharsets.UTF_8);
            ResponseEntity responseEntity = ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(saleUri)).header("Accept", new String[]{"application/json"})).header("Content-Type", new String[]{"application/json"})).header("Authorization", new String[]{auth})).body((Object)cartStr).retrieve().toEntity(DtoHksRespSale.class);
            return Map.of("httpStatus", responseEntity.getStatusCode().value(), "body", responseEntity.getBody());
        }
        catch (RestClientResponseException e) {
            return Map.of("httpStatus", e.getStatusCode().value(), "body", e.getResponseBodyAsString());
        }
        catch (RestClientException e) {
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
        catch (JsonProcessingException e) {
            return Map.of("ERC", 3, "ERM", e.getMessage());
        }
    }
}

