/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.feratel;

import de.rtb.pcon.features.partners.PartnerConfiguration;
import de.rtb.pcon.features.partners.feratel.FeratelConfigDto;
import de.rtb.pcon.features.partners.feratel.FeratelConfigService;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pcon/ui/areas/{id}/partners/feratel/"})
@PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
class FeratelController {
    @Autowired
    private FeratelConfigService cfgService;
    @Autowired
    private SecureEntityLoaderService entityLoader;

    FeratelController() {
    }

    @GetMapping(value={"config"})
    public FeratelConfigDto getConfig(@PathVariable int id) {
        Area area = this.entityLoader.loadArea(id);
        return (FeratelConfigDto)this.cfgService.fetchConfig(area);
    }

    @PostMapping(value={"config"})
    public void setConfig(@PathVariable int id, @RequestBody FeratelConfigDto config) {
        Area area = this.entityLoader.loadArea(id);
        this.cfgService.updateConfig(area, (PartnerConfiguration)config);
    }
}

