/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.brain_behind.crypto;

import de.rtb.pcon.features.partners.brain_behind.crypto.BrbCryptoService;
import de.rtb.pcon.features.partners.brain_behind.crypto.Rfc2898DeriveBytes;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class BrbCryptoServiceAESImpl
implements BrbCryptoService {
    private final String password;
    private final byte[] salt;
    private final byte[] key;
    private final byte[] iv;
    private final SecretKeySpec keySpec;
    private final AlgorithmParameterSpec ivSpec;
    private final Cipher cipher;

    public BrbCryptoServiceAESImpl(String password, String salt) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException, NoSuchPaddingException {
        this.password = password;
        this.salt = salt.getBytes(StandardCharsets.UTF_16LE);
        Rfc2898DeriveBytes deriveBytes = new Rfc2898DeriveBytes(this.password, this.salt);
        this.key = deriveBytes.getBytes(32);
        this.iv = deriveBytes.getBytes(16);
        this.keySpec = new SecretKeySpec(this.key, "AES");
        this.ivSpec = new IvParameterSpec(this.iv);
        this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
    }

    public String encryptBase64(String plainText) {
        String encodedVal;
        try {
            this.cipher.init(1, (Key)this.keySpec, this.ivSpec);
            byte[] encryptText = plainText.getBytes(StandardCharsets.UTF_16LE);
            int encryptTextLength = encryptText.length;
            byte[] encryptTextTransform = new byte[encryptTextLength + 2];
            System.arraycopy(encryptText, 0, encryptTextTransform, 2, encryptTextLength);
            encryptTextTransform[0] = -1;
            encryptTextTransform[1] = -2;
            byte[] encryptedVal = this.cipher.doFinal(encryptTextTransform, 0, encryptTextLength + 2);
            encodedVal = new String(Base64.getEncoder().encode(encryptedVal), StandardCharsets.UTF_8);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException ex) {
            encodedVal = ex.getMessage();
        }
        return encodedVal;
    }

    public String decryptBase64(String encodedVal) {
        try {
            this.cipher.init(2, (Key)this.keySpec, this.ivSpec);
            byte[] decodedVal = Base64.getDecoder().decode(encodedVal);
            byte[] decryptedVal = this.cipher.doFinal(decodedVal);
            int decryptedValLength = decryptedVal.length;
            byte[] decryptedValTransform = new byte[decryptedValLength - 2];
            System.arraycopy(decryptedVal, 2, decryptedValTransform, 0, decryptedValLength - 2);
            String decryptedText = new String(decryptedValTransform, StandardCharsets.UTF_16LE);
            return decryptedText;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException ex) {
            String decryptedText = ex.getMessage();
            return decryptedText;
        }
    }
}

