/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.legal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rtb.pcon.features.bonus.utils.JsonUtils;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.AreaCompany;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.repositories.AreaCompanyRepository;
import de.rtb.pcon.repositories.PaymentTransactionRepository;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ResponseStatusException;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring6.SpringTemplateEngine;
import org.xhtmlrenderer.pdf.ITextRenderer;

@Controller
@RequestMapping(value={"/legal"})
public class LegalController {
    private final MessageSource messageSource;
    private final SpringTemplateEngine templateEngine;
    private final PaymentTransactionRepository payRepo;
    private final PdmRepository pdmRepo;
    private final AreaCompanyRepository areaCompanyRepo;
    private static final TypeReference<HashMap<String, Object>> JSON_PROPERTIES_MAP_TYPE_REF = new /* Unavailable Anonymous Inner Class!! */;

    public LegalController(MessageSource messageSource, SpringTemplateEngine templateEngine, PaymentTransactionRepository payRepo, PdmRepository pdmRepo, AreaCompanyRepository areaCompanyRepo) {
        this.messageSource = messageSource;
        this.templateEngine = templateEngine;
        this.payRepo = payRepo;
        this.pdmRepo = pdmRepo;
        this.areaCompanyRepo = areaCompanyRepo;
    }

    @ResponseBody
    @GetMapping(value={"/invoice.pdf"})
    @Transactional(readOnly=true)
    ResponseEntity<byte[]> generateInvoicePdfNew(Locale locale, @RequestParam(name="pdm") int pdmNr, @RequestParam(name="gac") int areaNr, @RequestParam int tin, @RequestParam(name="tim") LocalDateTime sellTimeLocal) {
        ResponseEntity responseEntity;
        String timeFormat = this.messageSource.getMessage("page.legal.invoice.format.fullDateAndTime", null, locale);
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(timeFormat);
        Pdm pdm = (Pdm)this.pdmRepo.findByNumberAndZoneAreaId(pdmNr, areaNr).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Paring machine not found"));
        ZoneId zoneId = ZoneId.of(pdm.getZone().getArea().getTimeZoneName());
        OffsetDateTime sellTime = sellTimeLocal.atZone(zoneId).toOffsetDateTime();
        PaymentTransaction pay = (PaymentTransaction)this.payRepo.findByPdmAndTicket(pdm, sellTime, tin).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Parking ticket not found"));
        Area area = pdm.getZone().getArea();
        AreaCompany ac = this.areaCompanyRepo.findById((Object)area.getId()).orElseGet(() -> AreaCompany.createDefault((Area)area));
        BigDecimal vat = ac.getVatPercent().scaleByPowerOfTen(-2);
        NumberFormat currencyFormatter = NumberFormat.getCurrencyInstance(locale);
        currencyFormatter.setCurrency(Currency.getInstance(pay.getCurrency()));
        NumberFormat percentFormatter = NumberFormat.getPercentInstance(locale);
        percentFormatter.setMaximumFractionDigits(0);
        percentFormatter.setMaximumFractionDigits(2);
        Context context = new Context(locale);
        context.setVariable("companyName", (Object)ac.getName());
        context.setVariable("companyContact", ac.getContact().lines().toList());
        context.setVariable("companyLegalId", (Object)ac.getCompanyNumber());
        context.setVariable("companyTaxId", (Object)ac.getVatNumber());
        context.setVariable("town", (Object)pdm.getZone().getArea().getName());
        context.setVariable("zone", (Object)pdm.getZone().getName());
        context.setVariable("place", (Object)pdm.getName());
        context.setVariable("startDt", (Object)pay.getId().getPdmTime().atZoneSameInstant(zoneId).toLocalDateTime().format(dtf));
        context.setVariable("endDt", (Object)pay.getParkEndTime().atZoneSameInstant(zoneId).toLocalDateTime().format(dtf));
        context.setVariable("pdmNr", (Object)pdm.getNumber());
        context.setVariable("areaNr", (Object)pdm.getZone().getArea().getId());
        context.setVariable("lpn", (Object)pay.getLpn());
        context.setVariable("ticketNr", (Object)pay.getTicketNumber());
        String transId = Stream.of(pdm.getNumber(), pdm.getZone().getArea().getId(), pay.getId().getPdmTime(), pay.getId().getTrc()).map(x$0 -> Objects.toString(x$0)).collect(Collectors.joining(","));
        context.setVariable("transId", (Object)transId);
        Optional.ofNullable(pay.getData()).map(v -> (ObjectNode)JsonUtils.readValue((String)v, ObjectNode.class)).ifPresent(d -> {
            this.addTaxData(context, d, "jir", "tax1");
            this.addTaxData(context, d, "zki", "tax2");
            this.addTaxData(context, d, "eor", "tax1");
            this.addTaxData(context, d, "zoi", "tax2");
        });
        BigDecimal priceBrutto = pay.getAmount();
        BigDecimal priceNetto = priceBrutto.divide(vat.add(BigDecimal.ONE), 4, RoundingMode.HALF_UP);
        BigDecimal priceVat = priceBrutto.subtract(priceNetto);
        context.setVariable("vatPercent", (Object)percentFormatter.format(vat.doubleValue()));
        context.setVariable("priceBrutto", (Object)currencyFormatter.format(priceBrutto));
        context.setVariable("priceVat", (Object)currencyFormatter.format(priceVat));
        context.setVariable("priceNetto", (Object)currencyFormatter.format(priceNetto));
        Optional<HashMap> pdmCpuDevice = pay.getId().getPdm().getDevices().stream().filter(d -> "cpu".equals(d.getDeviceName())).findAny().map(d -> (HashMap)JsonUtils.readValue((String)d.getProperties(), (TypeReference)JSON_PROPERTIES_MAP_TYPE_REF));
        pdmCpuDevice.map(d -> d.get("ISU")).ifPresent(edid -> context.setVariable("edid", edid));
        pdmCpuDevice.map(d -> d.get("SP")).ifPresent(edid -> context.setVariable("bpdn", edid));
        String processedHtml = this.templateEngine.process("invoice", (IContext)context);
        Document document = Jsoup.parse((String)processedHtml, (String)"UTF-8");
        document.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ITextRenderer renderer = new ITextRenderer();
            renderer.getFontResolver().addFont(this.getClass().getClassLoader().getResource("fonts/verdana.ttf").toString(), "Identity-H", false, "Verdana");
            renderer.setDocumentFromString(document.html());
            renderer.layout();
            renderer.createPDF((OutputStream)outputStream);
            responseEntity = ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{"application/pdf"})).header("Content-Disposition", new String[]{"inline; filename=invoice.pdf"})).body((Object)outputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        outputStream.close();
        return responseEntity;
    }

    private void addTaxData(Context c, ObjectNode d, String name, String prefix) {
        Optional.ofNullable(d.get(name)).ifPresent(v -> {
            c.setVariable(prefix + "Name", (Object)name.toUpperCase());
            c.setVariable(prefix + "Value", (Object)v.asText());
        });
    }
}

