/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.gates;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.integration.PdmMessageProcessingException;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.bonus.gates.PresentTicketEntity;
import de.rtb.pcon.features.bonus.gates.PresentTicketPdmDto;
import de.rtb.pcon.features.bonus.gates.PresentTicketRepository;
import de.rtb.pcon.model.zone.Zone;
import java.time.ZoneId;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
class BonGateRtrRead
implements RealTimeRequest {
    @Autowired
    private PresentTicketRepository repo;
    @Autowired
    @Qualifier(value="pdmObjectMapper")
    private ObjectMapper pdmObjectMapper;

    BonGateRtrRead() {
    }

    public int getId() {
        return 36;
    }

    public String getDescription() {
        return "Gate, read ticket";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Zone zone = ctx.global().getPdm().getZone();
        if (zone == null) {
            throw new PdmMessageProcessingException("PDM must be in zone.");
        }
        String ticketNumber = ctx.getLocalString("tn");
        return this.repo.findByTicketNumberAndZone(ticketNumber, zone).map(t -> PresentTicketPdmDto.fromEntity((PresentTicketEntity)t, (ZoneId)ctx.global().getTimeZone(), (ObjectMapper)this.pdmObjectMapper)).map(t -> Map.of("tic", t)).orElse(Map.of());
    }
}

